/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.console.plugins.planning.PCCWaypoint;
import pt.lsts.neptus.console.plugins.planning.PCCWaypointPainter;
import pt.lsts.neptus.console.plugins.planning.PiccoloControlConfigurationPanel;
import pt.lsts.neptus.console.plugins.planning.PiccoloWPShowPreferencesPanel;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.MultiSystemIMCMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.StringUtils;
import pt.lsts.neptus.util.conf.StringProperty;

@PluginDescription(name="UAV Piccolo Control", author="Paulo Dias", version="1.0.0")
@LayerPriority(priority=40)
public class UavPiccoloControl
extends ConsolePanel
implements MainVehicleChangeListener,
ConfigurationListener,
IPeriodicUpdates,
Renderer2DPainter,
SubPanelChangeListener {
    private final Icon ICON_PICCOLO_WP_DOWNLOAD = ImageUtils.getScaledIcon("images/planning/piccolo-wps.png", 24, 24);
    private final Icon ICON_PICCOLO_WP_GOTO = ImageUtils.getScaledIcon("images/planning/piccolo-goto.png", 24, 24);
    private final Icon ICON_PICCOLO_WP_GOTO_HO = ImageUtils.getScaledIcon("images/planning/piccolo-goto-ho.png", 24, 24);
    private final Icon ICON_PICCOLO_WP_SHOW = ImageUtils.getScaledIcon("images/planning/piccolo-wp-show.png", 24, 24);
    private final Icon ICON_PICCOLO_WP_SHOW_FILTER = ImageUtils.getScaledIcon("images/planning/piccolo-wp-filter.png", 24, 24);
    private final Icon ICON_PICCOLO_WP_SHOW_CONFIG = ImageUtils.getScaledIcon("images/planning/piccolo-wp-filter-config.png", 24, 24);
    private final Icon ICON_CONFIG_DOWNLOAD = ImageUtils.getScaledIcon("images/planning/config-download.png", 24, 24);
    private final Icon ICON_EDIT = ImageUtils.getScaledIcon("images/planning/edit2.png", 24, 24);
    private static final Color COLOR_IDLE = Color.LIGHT_GRAY;
    private static final Color COLOR_ACCEPT = Color.GREEN;
    private static final Color COLOR_HANDOVER = new Color(255, 127, 0);
    @NeptusProperty(name="Font Size Multiplier", description="The font size. Use '1' for default.")
    public int fontMultiplier = 1;
    @NeptusProperty(name="Show Piccolo Waypoints")
    public boolean showWaypoints = true;
    @NeptusProperty(name="Filter to Show Only Main Vehicle's Piccolo Waypoints")
    public boolean filterMainVehicle = false;
    @NeptusProperty(name="Piccolo Plan Thickness")
    public float piccoloWpsThickness = 3.0f;
    private StringProperty pccColors = new StringProperty("0-99 (255,128,0)\n0-10 (255,255,0)\n");
    private Vector<ILayerPainter> renderers = new Vector();
    private MultiSystemIMCMessageListener multiSysListener = null;
    private String[] piccoloMsgsArray = new String[]{"PlanControlState", "PiccoloWaypoint", "PiccoloWaypointDeleted", "PiccoloTrackingState", "PiccoloControlConfiguration"};
    protected PCCWaypointPainter wptPainter = new PCCWaypointPainter();
    protected LinkedHashMap<String, PiccoloControlConfiguration> configs = new LinkedHashMap();
    protected LinkedHashMap<String, UavControlStateEnum> controlStates = new LinkedHashMap();
    protected LinkedHashMap<String, String> planStates = new LinkedHashMap();
    private JLabel titleLabel = null;
    private UavStateDisplay stateLabel = null;
    private ToolbarButton downloadAllWaypointsButton;
    private ToolbarButton downloadAllConfButton;
    private ToolbarButton editConfButton;
    private ToolbarButton handoverWaypointButton;
    private ToolbarButton showWPFilterWaypointButton;
    private ToolbarSwitch showWaypointsButton;
    private ToolbarSwitch showWaypointsFilterButton;
    private AbstractAction downloadAllWaypointsAction;
    private AbstractAction downloadAllConfAction;
    private AbstractAction editConfAction;
    private AbstractAction handoverWaypointAction;
    private AbstractAction showWaypointsAction;
    private AbstractAction showWaypointsFilterAction;
    private AbstractAction showWPFilterWaypointAction;

    public UavPiccoloControl(ConsoleLayout console) {
        super(console);
        this.initializeActions();
        this.initialize();
        this.wptPainter.setConfigsWaypoints(this.configs);
    }

    private void initialize() {
        this.removeAll();
        this.setSize(new Dimension(270, 60));
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(PluginUtils.getPluginName(this.getClass()));
        this.titleLabel.setFont(new Font("Arial", 1, 9 * this.fontMultiplier));
        this.add((Component)this.titleLabel, "North");
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 2));
        this.add((Component)tmpPanel, "Center");
        this.downloadAllWaypointsButton = new ToolbarButton(this.downloadAllWaypointsAction);
        tmpPanel.add((Component)((Object)this.downloadAllWaypointsButton));
        this.downloadAllConfButton = new ToolbarButton(this.downloadAllConfAction);
        tmpPanel.add((Component)((Object)this.downloadAllConfButton));
        this.showWaypointsButton = new ToolbarSwitch(this.showWaypointsAction);
        this.showWaypointsButton.setSelected(this.showWaypoints);
        tmpPanel.add(this.showWaypointsButton);
        this.showWaypointsFilterButton = new ToolbarSwitch(this.showWaypointsFilterAction);
        this.showWaypointsFilterButton.setSelected(this.filterMainVehicle);
        tmpPanel.add(this.showWaypointsFilterButton);
        this.showWPFilterWaypointButton = new ToolbarButton(this.showWPFilterWaypointAction);
        tmpPanel.add((Component)((Object)this.showWPFilterWaypointButton));
        tmpPanel.add(new JSeparator(1));
        this.stateLabel = new UavStateDisplay();
        this.stateLabel.setControlState(UavControlStateEnum.UNKNOWN);
        tmpPanel.add((Component)((Object)this.stateLabel));
        this.editConfButton = new ToolbarButton(this.editConfAction);
        tmpPanel.add((Component)((Object)this.editConfButton));
        this.handoverWaypointButton = new ToolbarButton(this.handoverWaypointAction);
        tmpPanel.add((Component)((Object)this.handoverWaypointButton));
    }

    private void initializeActions() {
        this.downloadAllWaypointsAction = new AbstractAction("Download Piccolo Waypoints", this.ICON_PICCOLO_WP_DOWNLOAD){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new Thread(){

                    @Override
                    public void run() {
                        String[] vlst;
                        if (UavPiccoloControl.this.isUAV(UavPiccoloControl.this.getMainVehicleId())) {
                            UavPiccoloControl.this.send(IMCDefinition.getInstance().create("ListPiccoloWaypoints", new Object[0]));
                            NeptusLog.pub().info((Object)("<###>----------Send to " + UavPiccoloControl.this.getMainVehicleId()));
                            System.out.flush();
                        }
                        for (String vehicleID : vlst = UavPiccoloControl.this.wptPainter.getVehiclesList()) {
                            if (vehicleID.equalsIgnoreCase(UavPiccoloControl.this.getMainVehicleId())) continue;
                            NeptusLog.pub().info((Object)("<###>----------Send to " + vehicleID));
                            System.out.flush();
                            ImcMsgManager.getManager().sendMessageToVehicle(IMCDefinition.getInstance().create("ListPiccoloWaypoints", new Object[0]), vehicleID, (String)null);
                        }
                    }
                }.start();
            }
        };
        this.downloadAllWaypointsAction.putValue("ShortDescription", "Download Piccolo Waypoints");
        this.downloadAllConfAction = new AbstractAction("Download Waypoints Configurations", this.ICON_CONFIG_DOWNLOAD){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new Thread(){

                    @Override
                    public void run() {
                        String[] vlst;
                        if (UavPiccoloControl.this.isUAV(UavPiccoloControl.this.getMainVehicleId())) {
                            UavPiccoloControl.this.send(IMCDefinition.getInstance().create("GetPiccoloControlConfiguration", new Object[0]));
                            NeptusLog.pub().info((Object)("<###>----------Send to " + UavPiccoloControl.this.getMainVehicleId()));
                            System.out.flush();
                        }
                        for (String vehicleID : vlst = UavPiccoloControl.this.wptPainter.getVehiclesList()) {
                            if (vehicleID.equalsIgnoreCase(UavPiccoloControl.this.getMainVehicleId())) continue;
                            NeptusLog.pub().info((Object)("<###>----------Send to " + vehicleID));
                            System.out.flush();
                            ImcMsgManager.getManager().sendMessageToVehicle(IMCDefinition.getInstance().create("GetPiccoloControlConfiguration", new Object[0]), vehicleID, (String)null);
                        }
                    }
                }.start();
            }
        };
        this.downloadAllConfAction.putValue("ShortDescription", "Download Waypoints Configurations");
        this.editConfAction = new AbstractAction("Edit Waypoints Configurations", this.ICON_EDIT){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new Thread(){

                    @Override
                    public void run() {
                        PiccoloControlConfigurationPanel confEdit;
                        PiccoloControlConfiguration ret;
                        PiccoloControlConfiguration conf;
                        if (UavPiccoloControl.this.isUAV(UavPiccoloControl.this.getMainVehicleId()) && (conf = UavPiccoloControl.this.configs.get(UavPiccoloControl.this.getMainVehicleId())) != null && (ret = (confEdit = new PiccoloControlConfigurationPanel()).showEditPanel(conf, SwingUtilities.getWindowAncestor(UavPiccoloControl.this))) != null) {
                            IMCMessage message = IMCDefinition.getInstance().create("PiccoloControlConfiguration", new Object[0]);
                            message.setValue("p_min", (Object)ret.planWpMin);
                            message.setValue("p_max", (Object)ret.planWpMax);
                            message.setValue("h_min", (Object)ret.handoverWpMin);
                            message.setValue("h_max", (Object)ret.handoverWpMax);
                            message.setValue("sw_radius", (Object)ret.serviceRadius);
                            message.setValue("sw_alt", (Object)ret.serviceAltitude);
                            message.setValue("sw_speed", (Object)ret.serviceSpeed);
                            UavPiccoloControl.this.send(message);
                        }
                    }
                }.start();
            }
        };
        this.editConfAction.putValue("ShortDescription", "Edit Waypoints Configurations");
        this.handoverWaypointAction = new AbstractAction("Handover", this.ICON_PICCOLO_WP_GOTO_HO){

            @Override
            public void actionPerformed(final ActionEvent aevt) {
                new Thread(){

                    @Override
                    public void run() {
                        String vid = UavPiccoloControl.this.getMainVehicleId();
                        if (UavPiccoloControl.this.isUAV(vid)) {
                            PiccoloControlConfiguration conf = UavPiccoloControl.this.configs.get(vid);
                            if (conf == null) {
                                return;
                            }
                            boolean ctrlOn = false;
                            boolean altOn = false;
                            boolean shiftOn = false;
                            if ((aevt.getModifiers() & 2) == 2) {
                                ctrlOn = true;
                            }
                            if ((aevt.getModifiers() & 8) == 8) {
                                altOn = true;
                            }
                            if ((aevt.getModifiers() & 1) == 1) {
                                shiftOn = true;
                            }
                            if (!(ctrlOn || altOn || shiftOn)) {
                                LinkedHashMap<Integer, PCCWaypoint> wps = UavPiccoloControl.this.wptPainter.getWaypoints(vid);
                                int choosenValue = -1;
                                Vector<String> wpL = new Vector<String>();
                                for (int wpn : wps.keySet()) {
                                    if (!conf.isHandhoverWP((short)wpn)) continue;
                                    wpL.add("Handover WP" + wpn);
                                    if (wpn <= choosenValue) continue;
                                    choosenValue = wpn;
                                    break;
                                }
                                if (choosenValue > 0) {
                                    UavPiccoloControl.this.send(IMCDefinition.getInstance().create("GotoPiccoloWaypoint", new Object[]{"index", choosenValue}));
                                }
                            } else if (ctrlOn) {
                                LinkedHashMap<Integer, PCCWaypoint> wps = UavPiccoloControl.this.wptPainter.getWaypoints(vid);
                                int initialValue = 0;
                                Vector<String> wpL = new Vector<String>();
                                for (int wpn : wps.keySet()) {
                                    if (conf.isHandhoverWP((short)wpn)) {
                                        wpL.add("Handover WP" + wpn);
                                        if (initialValue != 0) continue;
                                        initialValue = Math.max(0, wpL.size() - 1);
                                        continue;
                                    }
                                    if (!conf.isPlanWP((short)wpn) && shiftOn && altOn) {
                                        if (conf.isServiceWP((short)wpn)) {
                                            wpL.add("Service WP" + wpn);
                                            continue;
                                        }
                                        wpL.add("Plan WP" + wpn);
                                        continue;
                                    }
                                    if (!conf.isHandhoverWP((short)wpn) && !conf.isPlanWP((short)wpn) && shiftOn) {
                                        wpL.add("External WP" + wpn);
                                        continue;
                                    }
                                    if (!ctrlOn || !altOn) continue;
                                    wpL.add("Unknown WP" + wpn);
                                }
                                int userOpt = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(UavPiccoloControl.this), "Choose a waypoint", "GoTo waypoint", 2, 3, UavPiccoloControl.this.ICON_PICCOLO_WP_GOTO, wpL.toArray(new String[wpL.size()]), initialValue);
                                if (userOpt >= 0) {
                                    int idx = Integer.parseInt(((String)wpL.get(userOpt)).replaceAll("[\\s\\D]", ""));
                                    UavPiccoloControl.this.send(IMCDefinition.getInstance().create("GotoPiccoloWaypoint", new Object[]{"index", idx}));
                                }
                            }
                        }
                    }
                }.start();
            }
        };
        this.handoverWaypointAction.putValue("ShortDescription", "Handover");
        this.showWaypointsAction = new AbstractAction("Show waypoints", this.ICON_PICCOLO_WP_SHOW){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((e.getModifiers() & 2) == 2 && !((ToolbarSwitch)e.getSource()).isSelected()) {
                    GuiUtils.errorMessage(SwingUtilities.getWindowAncestor(UavPiccoloControl.this), new Exception("adsdasda"));
                }
                UavPiccoloControl.this.showWaypoints = ((ToolbarSwitch)e.getSource()).isSelected();
            }
        };
        this.showWaypointsAction.putValue("ShortDescription", "Show only main vehicle");
        this.showWaypointsFilterAction = new AbstractAction("Show only main vehicle", this.ICON_PICCOLO_WP_SHOW_FILTER){

            @Override
            public void actionPerformed(ActionEvent e) {
                UavPiccoloControl.this.filterMainVehicle = ((ToolbarSwitch)e.getSource()).isSelected();
            }
        };
        this.showWaypointsFilterAction.putValue("ShortDescription", "Show only main vehicle");
        this.showWPFilterWaypointAction = new AbstractAction("Edit Visual Filter Configurations", this.ICON_PICCOLO_WP_SHOW_CONFIG){

            @Override
            public void actionPerformed(final ActionEvent aevt) {
                new Thread(){

                    @Override
                    public void run() {
                        boolean ctrlOn = false;
                        boolean altOn = false;
                        boolean shiftOn = false;
                        if ((aevt.getModifiers() & 2) == 2) {
                            ctrlOn = true;
                        }
                        if ((aevt.getModifiers() & 8) == 8) {
                            altOn = true;
                        }
                        if ((aevt.getModifiers() & 1) == 1) {
                            shiftOn = true;
                        }
                        if (!(ctrlOn || altOn || shiftOn)) {
                            PiccoloWPShowPreferencesPanel confEdit = new PiccoloWPShowPreferencesPanel();
                            boolean ret = confEdit.showEditPanel(UavPiccoloControl.this.wptPainter.isPaintHandoverWP(), UavPiccoloControl.this.wptPainter.isPaintExternalWP(), SwingUtilities.getWindowAncestor(UavPiccoloControl.this));
                            if (ret) {
                                UavPiccoloControl.this.wptPainter.setPaintHandoverWP(confEdit.isHandoverWPVisible());
                                UavPiccoloControl.this.wptPainter.setPaintExternalWP(confEdit.isExternalWPVisible());
                            }
                        } else if (shiftOn) {
                            UavPiccoloControl.this.wptPainter.setPaintHandoverWP(false);
                            UavPiccoloControl.this.wptPainter.setPaintExternalWP(false);
                        } else if (ctrlOn && altOn) {
                            UavPiccoloControl.this.wptPainter.setPaintHandoverWP(true);
                            UavPiccoloControl.this.wptPainter.setPaintExternalWP(true);
                        } else if (ctrlOn && !altOn) {
                            UavPiccoloControl.this.wptPainter.setPaintHandoverWP(true);
                            UavPiccoloControl.this.wptPainter.setPaintExternalWP(false);
                        } else if (!ctrlOn && altOn) {
                            UavPiccoloControl.this.wptPainter.setPaintHandoverWP(false);
                            UavPiccoloControl.this.wptPainter.setPaintExternalWP(true);
                        }
                    }
                }.start();
            }
        };
        this.showWPFilterWaypointAction.putValue("ShortDescription", "Edit Visual Filter Configurations");
    }

    @Override
    public void initSubPanel() {
        this.wptPainter.setThickness(this.piccoloWpsThickness);
        this.getMultiSysListener();
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.addPostRenderPainter(this, this.getClass().getSimpleName());
        }
    }

    @Override
    public void cleanSubPanel() {
        this.getMultiSysListener().clean();
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.removePostRenderPainter(this);
        }
    }

    private boolean isUAV(String id) {
        String mId = this.getMainVehicleId();
        ImcSystem sysM = ImcSystemsHolder.lookupSystemByName(mId);
        return sysM != null && sysM.getType() == VehicleType.SystemTypeEnum.VEHICLE && sysM.getTypeVehicle() == VehicleType.VehicleTypeEnum.UAV;
    }

    @Override
    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (panelChange == null) {
            return;
        }
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), ILayerPainter.class)) {
            ILayerPainter str2d;
            ILayerPainter sub = (ILayerPainter)((Object)panelChange.getPanel());
            if (panelChange.added()) {
                this.renderers.add(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addPostRenderPainter(this, "LBL Tracker Range");
                }
            }
            if (panelChange.removed()) {
                this.renderers.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removePostRenderPainter(this);
                }
            }
        }
    }

    @Override
    public void propertiesChanged() {
        this.wptPainter.setThickness(this.piccoloWpsThickness);
        this.wptPainter.colors = new WaypointColors(this.pccColors.toString());
        if (this.showWaypoints != this.showWaypointsButton.isSelected()) {
            this.showWaypointsButton.setSelected(this.showWaypoints);
        }
        if (this.filterMainVehicle != this.showWaypointsFilterButton.isSelected()) {
            this.showWaypointsFilterButton.setSelected(this.filterMainVehicle);
        }
    }

    @Override
    public long millisBetweenUpdates() {
        return 500L;
    }

    @Override
    public boolean update() {
        if (this.isUAV(this.getMainVehicleId())) {
            if (this.configs.containsKey(this.getMainVehicleId())) {
                this.editConfAction.setEnabled(true);
            } else {
                this.editConfAction.setEnabled(false);
            }
            this.handoverWaypointAction.setEnabled(true);
        } else {
            this.editConfAction.setEnabled(false);
            this.handoverWaypointAction.setEnabled(false);
        }
        for (String id : this.configs.keySet()) {
            try {
                int wpTo = this.wptPainter.getDestinationWaypoint(id);
                PiccoloControlConfiguration pCConfig = this.configs.get(id);
                String pState = this.planStates.get(id);
                UavControlStateEnum cState = this.controlStates.get(id);
                if (cState == null) {
                    cState = UavControlStateEnum.UNKNOWN;
                }
                if (pCConfig == null) {
                    cState = UavControlStateEnum.UNKNOWN;
                } else if (wpTo < 0) {
                    cState = UavControlStateEnum.EXTERNAL;
                } else if (pCConfig.isHandhoverWP((short)wpTo)) {
                    cState = UavControlStateEnum.HANDOVER_READY;
                } else if (pCConfig.isPlanWP((short)wpTo)) {
                    cState = UavControlStateEnum.PLAN_READY;
                    if (pState != null && !"READY".equalsIgnoreCase(pState)) {
                        cState = UavControlStateEnum.EXECUTING;
                    }
                } else {
                    cState = UavControlStateEnum.EXTERNAL;
                }
                this.controlStates.put(id, cState);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.controlStates.put(id, UavControlStateEnum.UNKNOWN);
            }
        }
        String mId = this.getMainVehicleId();
        ImcSystem sysM = ImcSystemsHolder.lookupSystemByName(mId);
        if (sysM == null || sysM.getType() != VehicleType.SystemTypeEnum.VEHICLE || sysM.getTypeVehicle() != VehicleType.VehicleTypeEnum.UAV || this.controlStates.get(mId) == null) {
            this.stateLabel.setControlState(UavControlStateEnum.UNKNOWN);
        } else {
            UavControlStateEnum csM = this.controlStates.get(mId);
            this.stateLabel.setControlState(csM);
        }
        this.wptPainter.setMainVehicle(mId);
        this.updateVisibleVehiclesWaypoints();
        return true;
    }

    private void updateVisibleVehiclesWaypoints() {
        String[] vList = this.wptPainter.getVehiclesList();
        if (vList.length == 0) {
            return;
        }
        for (String veh : vList) {
            if (!this.filterMainVehicle) {
                this.wptPainter.setVehicleWaypointsVisible(veh, true);
                continue;
            }
            if (veh.equalsIgnoreCase(this.wptPainter.getMainVehicle())) {
                this.wptPainter.setVehicleWaypointsVisible(veh, true);
                continue;
            }
            this.wptPainter.setVehicleWaypointsVisible(veh, false);
        }
    }

    private MultiSystemIMCMessageListener getMultiSysListener() {
        if (this.multiSysListener == null) {
            this.multiSysListener = new MultiSystemIMCMessageListener(this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "]"){

                @Override
                public void messageArrived(ImcId16 id, IMCMessage message) {
                    try {
                        PiccoloWPType wpt = PiccoloWPType.getType(message.getMessageType().getShortName());
                        String vid = VehiclesHolder.getVehicleWithImc(id).getId();
                        PCCWaypoint w = UavPiccoloControl.parseWaypoint(message);
                        if (StringUtils.isTokenInList("PiccoloWaypoint", message.getAbbrev())) {
                            NeptusLog.pub().info((Object)("<###>received waypoint " + w.getId() + " attached to vehicle " + vid));
                        }
                        switch (wpt) {
                            case WAYPOINT_ADD: {
                                PCCWaypoint waypoint = UavPiccoloControl.parseWaypoint(message);
                                UavPiccoloControl.this.wptPainter.setWaypoint(vid, waypoint);
                                UavPiccoloControl.this.callRepaint();
                                break;
                            }
                            case WAYPOINT_REMOVE: {
                                int deleted = UavPiccoloControl.parseDeletedId(message);
                                if (deleted != -1) {
                                    UavPiccoloControl.this.wptPainter.deleteWaypoint(vid, deleted);
                                }
                                UavPiccoloControl.this.callRepaint();
                                break;
                            }
                            case WAYPOINTTRACKED_ID: {
                                ImcSystem sys;
                                String status = message.getString("status").toUpperCase();
                                int wpt_to = message.getInteger("to");
                                int wpt_from = message.getInteger("from");
                                if ("OFF".equalsIgnoreCase(status)) {
                                    wpt_to = -1;
                                }
                                UavPiccoloControl.this.wptPainter.setDestinationWaypoint(vid, wpt_to);
                                UavPiccoloControl.this.wptPainter.setSourceWaypoint(vid, wpt_from);
                                if (UavPiccoloControl.this.getConsole() != null && (sys = ImcSystemsHolder.lookupSystemByName(vid)) != null) {
                                    UavPiccoloControl.this.wptPainter.setVehiclePosition(vid, sys.getLocation());
                                }
                                UavPiccoloControl.this.callRepaint();
                                break;
                            }
                            case CONFIG_MSG: {
                                PiccoloControlConfiguration pCConf = UavPiccoloControl.this.parsePiccoloControlConfiguration(message);
                                UavPiccoloControl.this.configs.put(vid, pCConf);
                                break;
                            }
                            case PLAN_STATE: {
                                if (!UavPiccoloControl.this.configs.containsKey(vid)) break;
                                UavPiccoloControl.this.planStates.put(vid, message.getString("state"));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            this.multiSysListener.setSystemToListen(new ImcId16[0]);
            this.multiSysListener.setMessagesToListen(this.piccoloMsgsArray);
        }
        return this.multiSysListener;
    }

    protected void callRepaint() {
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.showWaypoints) {
            this.wptPainter.paint(g, renderer);
        }
    }

    private static PCCWaypoint parseWaypoint(IMCMessage message) {
        if (message == null) {
            return null;
        }
        if (PiccoloWPType.getType(message.getMessageType().getShortName()) == PiccoloWPType.WAYPOINT_ADD) {
            LocationType loc = new LocationType();
            loc.setLatitudeDegs(Math.toDegrees(message.getDouble("lat")));
            loc.setLongitudeDegs(Math.toDegrees(message.getDouble("lon")));
            loc.setDepth(message.getDouble("depth"));
            PCCWaypoint wpt = new PCCWaypoint(message.getInteger("index"), message.getInteger("next"), loc, message.getFloat("lradius"));
            return wpt;
        }
        return null;
    }

    private static int parseDeletedId(IMCMessage message) {
        if (message == null) {
            return -1;
        }
        if (PiccoloWPType.getType(message.getMessageType().getShortName()) == PiccoloWPType.WAYPOINT_REMOVE) {
            return message.getInteger("index");
        }
        return -1;
    }

    private PiccoloControlConfiguration parsePiccoloControlConfiguration(IMCMessage message) {
        if (message == null) {
            return new PiccoloControlConfiguration();
        }
        PiccoloControlConfiguration ret = new PiccoloControlConfiguration();
        if (PiccoloWPType.getType(message.getMessageType().getShortName()) == PiccoloWPType.CONFIG_MSG) {
            ret.setPlanWpMin((short)message.getInteger("p_min"));
            ret.setPlanWpMax((short)message.getInteger("p_max"));
            ret.setHandoverWpMin((short)message.getInteger("h_min"));
            ret.setHandoverWpMax((short)message.getInteger("h_max"));
            ret.setServiceRadius(message.getDouble("sw_radius"));
            ret.setServiceAltitude(message.getDouble("sw_alt"));
            ret.setServiceSpeed(message.getDouble("sw_speed"));
        }
        return ret;
    }

    private static class UavStateDisplay
    extends JXPanel {
        private static final Color COLOR_IDLE = new JXPanel().getBackground();
        private JXLabel label = null;
        private UavControlStateEnum controlState = UavControlStateEnum.UNKNOWN;
        private RectanglePainter rectPainter;
        private CompoundPainter<JXPanel> compoundBackPainter;

        public UavStateDisplay() {
            this.initialize();
        }

        private void initialize() {
            this.setBackgroundPainter((Painter)this.getCompoundBackPainter());
            this.label = new JXLabel("<html><b>" + this.controlState.getPrettyPrintString().replaceAll(" ", "<br>"), 0);
            this.label.setHorizontalTextPosition(0);
            this.label.setHorizontalAlignment(0);
            this.label.setFont(new Font("Arial", 1, 11));
            this.label.setForeground(Color.WHITE);
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
            this.setPreferredSize(new Dimension(215, 180));
            this.setSize(new Dimension(215, 180));
        }

        public void setControlState(UavControlStateEnum controlState) {
            this.controlState = controlState;
            this.label.setText("<html><b>" + controlState.getPrettyPrintString().replaceAll(" ", "<br>"));
            this.updateBackColor(this.controlState.getColor());
        }

        private RectanglePainter getRectPainter() {
            if (this.rectPainter == null) {
                this.rectPainter = new RectanglePainter(5, 5, 5, 5, 20, 20);
                this.rectPainter.setFillPaint((Paint)COLOR_IDLE);
                this.rectPainter.setBorderPaint((Paint)COLOR_IDLE.darker().darker().darker());
                this.rectPainter.setStyle(AbstractAreaPainter.Style.BOTH);
                this.rectPainter.setBorderWidth(2.0f);
                this.rectPainter.setAntialiasing(true);
            }
            return this.rectPainter;
        }

        private CompoundPainter<JXPanel> getCompoundBackPainter() {
            this.compoundBackPainter = new CompoundPainter(new Painter[]{this.getRectPainter(), new GlossPainter()});
            return this.compoundBackPainter;
        }

        private void updateBackColor(Color color) {
            this.getRectPainter().setFillPaint((Paint)color);
            this.getRectPainter().setBorderPaint((Paint)color.darker());
            this.repaint();
        }
    }

    public static class PiccoloControlConfiguration
    implements Cloneable {
        short planWpMin = (short)-1;
        short planWpMax = (short)-1;
        short handoverWpMin = (short)-1;
        short handoverWpMax = (short)-1;
        double serviceRadius = -1.0;
        double serviceAltitude = -1.0;
        double serviceSpeed = -1.0;

        public static PiccoloControlConfiguration createDefault() {
            PiccoloControlConfiguration ret = new PiccoloControlConfiguration();
            ret.planWpMin = (short)20;
            ret.planWpMax = (short)69;
            ret.handoverWpMin = (short)19;
            ret.handoverWpMax = (short)19;
            ret.serviceRadius = 100.0;
            return ret;
        }

        protected Object clone() throws CloneNotSupportedException {
            PiccoloControlConfiguration ret = new PiccoloControlConfiguration();
            ret.planWpMin = this.planWpMin;
            ret.planWpMax = this.planWpMax;
            ret.handoverWpMin = this.handoverWpMin;
            ret.handoverWpMax = this.handoverWpMax;
            ret.serviceRadius = this.serviceRadius;
            ret.serviceAltitude = this.serviceAltitude;
            ret.serviceSpeed = this.serviceSpeed;
            return ret;
        }

        public boolean isPlanWP(short wp) {
            if (this.planWpMin < 0 || this.planWpMax < 0) {
                return false;
            }
            return this.planWpMin <= wp && wp <= this.planWpMax;
        }

        public boolean isHandhoverWP(short wp) {
            if (this.handoverWpMin < 0 || this.handoverWpMax < 0) {
                return false;
            }
            return this.handoverWpMin <= wp && wp <= this.handoverWpMax;
        }

        public boolean isServiceWP(short wp) {
            if (this.isPlanWP(wp)) {
                return wp == this.getServiceWp();
            }
            return false;
        }

        public boolean isExternalWP(short wp) {
            return !this.isPlanWP(wp) && !this.isHandhoverWP(wp);
        }

        public short getServiceWp() {
            return this.planWpMax;
        }

        public short getPlanWpMin() {
            return this.planWpMin;
        }

        public void setPlanWpMin(short planWpMin) {
            this.planWpMin = planWpMin;
        }

        public short getPlanWpMax() {
            return this.planWpMax;
        }

        public void setPlanWpMax(short planWpMax) {
            this.planWpMax = planWpMax;
        }

        public short getHandoverWpMin() {
            return this.handoverWpMin;
        }

        public void setHandoverWpMin(short handoverWpMin) {
            this.handoverWpMin = handoverWpMin;
        }

        public short getHandoverWpMax() {
            return this.handoverWpMax;
        }

        public void setHandoverWpMax(short handoverWpMax) {
            this.handoverWpMax = handoverWpMax;
        }

        public double getServiceRadius() {
            return this.serviceRadius;
        }

        public void setServiceRadius(double serviceRadius) {
            this.serviceRadius = serviceRadius;
        }

        public double getServiceAltitude() {
            return this.serviceAltitude;
        }

        public void setServiceAltitude(double serviceAltitude) {
            this.serviceAltitude = serviceAltitude;
        }

        public double getServiceSpeed() {
            return this.serviceSpeed;
        }

        public void setServiceSpeed(double serviceSpeed) {
            this.serviceSpeed = serviceSpeed;
        }
    }

    static class WaypointColors {
        LinkedHashMap<Integer, Color> colors = new LinkedHashMap();
        LinkedHashMap<Interval, Color> intervals = new LinkedHashMap();

        public WaypointColors(String colors) {
            String[] lines = colors.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].startsWith("#")) continue;
                try {
                    String[] parts = lines[i].split("[ \\-\\(,\\)]+");
                    if (parts.length < 5) {
                        for (String p : parts) {
                            NeptusLog.pub().info((Object)("<###> " + p + " --- "));
                        }
                        throw new Exception("Syntax Error on line " + (i + 1) + ", " + parts.length);
                    }
                    int min = Integer.parseInt(parts[0]);
                    int max = Integer.parseInt(parts[1]);
                    int red = Integer.parseInt(parts[2]);
                    int green = Integer.parseInt(parts[3]);
                    int blue = Integer.parseInt(parts[4]);
                    Interval in = new Interval(min, max);
                    Color c = new Color(red, green, blue);
                    this.intervals.put(in, c);
                    continue;
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)("PCC Waypoint Colors: Syntax error on line " + (i + 1)), (Throwable)e);
                }
            }
        }

        Color getColor(int wptNumber) {
            if (!this.colors.containsKey(wptNumber)) {
                Color defColor = Color.orange;
                for (Interval i : this.intervals.keySet()) {
                    if (!i.contains(wptNumber)) continue;
                    defColor = this.intervals.get(i);
                }
                this.colors.put(wptNumber, defColor);
            }
            return this.colors.get(wptNumber);
        }
    }

    static class Interval {
        Number min = 0;
        Number max = 0;

        public Interval(Number min, Number max) {
            this.min = min;
            this.max = max;
        }

        public boolean contains(Number value) {
            return this.max.doubleValue() >= value.doubleValue() && value.doubleValue() >= this.min.doubleValue();
        }

        public int hashCode() {
            return (this.min.toString() + "->" + this.max.toString()).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Interval) {
                return ((Interval)obj).min.doubleValue() == this.min.doubleValue() && ((Interval)obj).max.doubleValue() == this.max.doubleValue();
            }
            return false;
        }
    }

    public static enum PiccoloWPType {
        WAYPOINT_UNKOWN(""),
        WAYPOINT_ADD("PiccoloWaypoint"),
        WAYPOINT_REMOVE("PiccoloWaypointDeleted"),
        WAYPOINTTRACKED_ID("PiccoloTrackingState"),
        CONFIG_MSG("PiccoloControlConfiguration"),
        PLAN_STATE("PlanControlState");

        private final String pWPType;

        private PiccoloWPType(String pwpt) {
            this.pWPType = pwpt;
        }

        public String type() {
            return this.pWPType;
        }

        public static final PiccoloWPType getType(String type) {
            for (PiccoloWPType val : PiccoloWPType.values()) {
                if (!val.type().equalsIgnoreCase(type)) continue;
                return val;
            }
            return WAYPOINT_UNKOWN;
        }
    }

    public static enum UavControlStateEnum {
        UNKNOWN,
        EXTERNAL,
        HANDOVER_READY,
        PLAN_READY,
        EXECUTING;


        public Color getColor() {
            switch (this) {
                case EXTERNAL: {
                    return COLOR_IDLE;
                }
                case HANDOVER_READY: {
                    return COLOR_HANDOVER;
                }
                case PLAN_READY: 
                case EXECUTING: {
                    return COLOR_ACCEPT;
                }
            }
            return COLOR_IDLE;
        }

        public String getPrettyPrintString() {
            String ret = this.toString().toLowerCase().replaceFirst("_r", " R");
            ret = ret.substring(0, 1).toUpperCase() + ret.substring(1);
            return ret;
        }
    }
}

