/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.edit;

import java.util.Collection;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.types.mission.TransitionType;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class ManeuverAdded
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected PlanType plan;
    protected Maneuver maneuver;
    protected Vector<TransitionType> addedTransitions = new Vector();
    protected Vector<TransitionType> removedTransitions = new Vector();
    protected boolean initial = false;

    public ManeuverAdded(Maneuver maneuver, PlanType plan, Collection<TransitionType> addedTransitions, Collection<TransitionType> removedTransitions) {
        this.maneuver = maneuver;
        this.plan = plan;
        this.addedTransitions.addAll(addedTransitions);
        this.removedTransitions.addAll(removedTransitions);
        this.initial = maneuver.isInitialManeuver();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return I18n.textf("Add the maneuver %maneuverId", this.maneuver.getId());
    }

    @Override
    public void undo() throws CannotUndoException {
        for (TransitionType tt : this.addedTransitions) {
            if (tt == null) continue;
            this.plan.getGraph().removeTransition(tt);
        }
        this.plan.getGraph().removeManeuver(this.maneuver);
        for (TransitionType tt : this.removedTransitions) {
            if (tt == null) continue;
            this.plan.getGraph().addTransition(tt);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        for (TransitionType tt : this.removedTransitions) {
            if (tt == null) continue;
            this.plan.getGraph().removeTransition(tt);
        }
        this.plan.getGraph().addManeuver(this.maneuver);
        for (TransitionType tt : this.addedTransitions) {
            if (tt == null) continue;
            this.plan.getGraph().addTransition(tt);
        }
        if (this.initial) {
            this.plan.getGraph().setInitialManeuver(this.maneuver.getId());
        }
    }

    public Maneuver getManeuver() {
        return this.maneuver;
    }

    public PlanType getPlan() {
        return this.plan;
    }
}

