/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.edit;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class ManeuverChanged
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected PlanType plan;
    protected Maneuver maneuver;
    protected String beforeXml;
    protected String afterXml;

    public ManeuverChanged(Maneuver maneuver, PlanType plan, String beforeXml) {
        this.maneuver = maneuver;
        this.plan = plan;
        this.beforeXml = beforeXml;
        this.afterXml = maneuver.getManeuverXml();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return I18n.textf("Change the maneuver %maneuverId", this.maneuver.getId());
    }

    @Override
    public void undo() throws CannotUndoException {
        this.maneuver.loadManeuverXml(this.beforeXml);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.maneuver.loadManeuverXml(this.afterXml);
    }

    public Maneuver getManeuver() {
        return this.maneuver;
    }

    public PlanType getPlan() {
        return this.plan;
    }
}

