/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.edit;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.undo.UndoManager;
import pt.lsts.neptus.console.plugins.planning.edit.ManeuverChanged;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.params.ManeuverPayloadConfig;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class ManeuverPropertiesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected PropertySheetPanel propsPanel = new PropertySheetPanel();
    protected JPanel controls = new JPanel();
    protected JToggleButton editBtn = new JToggleButton(I18n.text("Edit"), ImageUtils.getScaledIcon("images/planning/man_edit.png", 16, 16));
    protected JButton deleteBtn = new JButton(I18n.text("Delete"), ImageUtils.getScaledIcon("images/planning/man_remove.png", 16, 16));
    protected Maneuver maneuver;
    protected String beforeXml = null;
    protected boolean changed = false;
    protected UndoManager manager = new UndoManager();
    protected PlanType plan;
    protected ManeuverPayloadConfig payloadConfig = null;

    public ManeuverPropertiesPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(I18n.text("No maneuver selected")));
        this.add((Component)this.propsPanel, "Center");
        this.controls.setLayout(new GridLayout(1, 0));
        this.controls.add(this.deleteBtn);
        this.controls.add(this.editBtn);
        this.editBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.add((Component)this.controls, "South");
        this.propsPanel.setDescriptionVisible(true);
        this.propsPanel.setMode(1);
        this.propsPanel.addPropertySheetChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ManeuverPropertiesPanel.this.setProps();
            }
        });
        this.propsPanel.setEditorFactory((PropertyEditorFactory)PropertiesEditor.getPropertyEditorRegistry());
        this.propsPanel.setRendererFactory((PropertyRendererFactory)PropertiesEditor.getPropertyRendererRegistry());
        this.propsPanel.setToolBarVisible(false);
    }

    public Maneuver getManeuver() {
        return this.maneuver;
    }

    public void setProps() {
        String before = this.maneuver.getManeuverXml();
        this.payloadConfig.setProperties(this.propsPanel.getProperties());
        boolean wasInitialManeuver = this.maneuver.isInitialManeuver();
        this.maneuver.setProperties(this.propsPanel.getProperties());
        if (this.maneuver.isInitialManeuver()) {
            this.plan.getGraph().setInitialManeuver(this.maneuver.getId());
        } else if (wasInitialManeuver) {
            this.maneuver.setInitialManeuver(true);
            this.setManeuver(this.maneuver);
            return;
        }
        this.propsPanel.removePropertyChangeListener((PropertyChangeListener)this.payloadConfig);
        if (this.manager != null) {
            this.manager.addEdit(new ManeuverChanged(this.maneuver, this.plan, before));
        }
        this.changed = true;
    }

    public void setManeuver(Maneuver man) {
        if (this.maneuver != null && this.propsPanel.getTable().getEditorComponent() != null) {
            this.propsPanel.getTable().commitEditing();
            this.setProps();
        }
        String vehicle = "unknown";
        if (this.plan != null) {
            vehicle = this.plan.getVehicle();
        }
        this.payloadConfig = new ManeuverPayloadConfig(vehicle, man, this.propsPanel);
        this.maneuver = man;
        this.editBtn.setSelected(false);
        this.changed = false;
        if (man == null) {
            this.setBorder(new TitledBorder(I18n.text("No maneuver selected")));
            try {
                this.propsPanel.setProperties(new Property[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.editBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            return;
        }
        this.beforeXml = man.getManeuverXml();
        DefaultProperty[] manProps = man.getProperties();
        DefaultProperty[] payloadProps = new ManeuverPayloadConfig(vehicle, man, this.propsPanel).getProperties();
        Property[] combinedProps = new Property[manProps.length + payloadProps.length];
        for (int i = 0; i < manProps.length; ++i) {
            combinedProps[i] = manProps[i];
        }
        for (int j = 0; j < payloadProps.length; ++j) {
            combinedProps[j + i] = payloadProps[j];
        }
        this.propsPanel.setProperties(combinedProps);
        this.setBorder(new TitledBorder(man.getId()));
        this.deleteBtn.setEnabled(true);
        this.editBtn.setSelected(false);
        if (this.maneuver instanceof StateRendererInteraction) {
            this.editBtn.setEnabled(true);
        } else {
            this.editBtn.setEnabled(false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public String getBeforeXml() {
        return this.beforeXml;
    }

    public JToggleButton getEditBtn() {
        return this.editBtn;
    }

    public JButton getDeleteBtn() {
        return this.deleteBtn;
    }

    public UndoManager getManager() {
        return this.manager;
    }

    public void setManager(UndoManager manager) {
        this.manager = manager;
    }

    public PlanType getPlan() {
        return this.plan;
    }

    public void setPlan(PlanType plan) {
        this.plan = plan;
    }

    public static void main(String[] args) {
        Goto gotoM = new Goto();
        ManeuverPropertiesPanel props = new ManeuverPropertiesPanel();
        GuiUtils.testFrame(props);
        props.setManeuver(gotoM);
    }
}

