/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.edit;

import java.util.LinkedHashMap;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanDepthChanged
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected LinkedHashMap<String, Double> previousDepths = new LinkedHashMap();
    protected double newDepth;
    protected PlanType plan;

    public PlanDepthChanged(PlanType plan, double newDepth, LinkedHashMap<String, Double> previousDepths) {
        this.plan = plan;
        this.newDepth = newDepth;
        this.previousDepths = previousDepths;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return I18n.textf("Set plan depth to %newDepth", this.newDepth);
    }

    @Override
    public void undo() throws CannotUndoException {
        for (String key : this.previousDepths.keySet()) {
            Maneuver m = this.plan.getGraph().getManeuver(key);
            if (!(m instanceof LocatedManeuver)) continue;
            ManeuverLocation loc = ((LocatedManeuver)((Object)m)).getManeuverLocation();
            loc.setAbsoluteDepth(this.previousDepths.get(key));
            ((LocatedManeuver)((Object)m)).getManeuverLocation().setLocation(loc);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        for (Maneuver m : this.plan.getGraph().getAllManeuvers()) {
            if (!(m instanceof LocatedManeuver)) continue;
            ManeuverLocation loc = ((LocatedManeuver)((Object)m)).getManeuverLocation();
            loc.setAbsoluteDepth(this.newDepth);
            ((LocatedManeuver)((Object)m)).getManeuverLocation().setLocation(loc);
        }
    }

    public PlanType getPlan() {
        return this.plan;
    }

    public double getNewDepth() {
        return this.newDepth;
    }

    public LinkedHashMap<String, Double> getPreviousDepths() {
        return this.previousDepths;
    }
}

