/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.edit;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.AngleCalc;

public class PlanRotated
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected PlanType plan;
    protected LocatedManeuver pivot;
    protected double angleRads;

    public PlanRotated(PlanType plan, LocatedManeuver pivot, double angleRads) {
        this.plan = plan;
        this.pivot = pivot;
        this.angleRads = angleRads;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return I18n.text("Rotate the plan");
    }

    @Override
    public void undo() throws CannotUndoException {
        for (Maneuver m : this.plan.getGraph().getAllManeuvers()) {
            if (m == this.pivot || !(m instanceof LocatedManeuver)) continue;
            LocatedManeuver satellite = (LocatedManeuver)((Object)m);
            double[] top = this.pivot.getManeuverLocation().getDistanceInPixelTo(satellite.getManeuverLocation(), 22);
            double[] topR = AngleCalc.rotate(2.0 * -this.angleRads, top[0], top[1], false);
            double deltaX = topR[0];
            double deltaY = topR[1];
            LocationType lt = new LocationType(this.pivot.getManeuverLocation());
            lt.translateInPixel(deltaX, deltaY, 22);
            lt.setAbsoluteDepth(satellite.getManeuverLocation().getAllZ());
            ManeuverLocation l = satellite.getManeuverLocation();
            l.setLocation(lt);
            satellite.setManeuverLocation(l);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        for (Maneuver m : this.plan.getGraph().getAllManeuvers()) {
            if (m == this.pivot || !(m instanceof LocatedManeuver)) continue;
            LocatedManeuver satellite = (LocatedManeuver)((Object)m);
            double[] top = this.pivot.getManeuverLocation().getDistanceInPixelTo(satellite.getManeuverLocation(), 22);
            double[] topR = AngleCalc.rotate(2.0 * this.angleRads, top[0], top[1], false);
            double deltaX = topR[0];
            double deltaY = topR[1];
            LocationType lt = new LocationType(this.pivot.getManeuverLocation());
            lt.translateInPixel(deltaX, deltaY, 22);
            lt.setAbsoluteDepth(satellite.getManeuverLocation().getAllZ());
            ManeuverLocation l = satellite.getManeuverLocation();
            l.setLocation(lt);
            satellite.setManeuverLocation(l);
        }
    }

    public PlanType getPlan() {
        return this.plan;
    }

    public LocatedManeuver getPivot() {
        return this.pivot;
    }

    public double getAngle() {
        return this.angleRads;
    }
}

