/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.edit;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.commons.lang.StringUtils;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanSettingsChanged
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected LinkedHashMap<String, Vector<DefaultProperty>> previousSettings;
    protected Collection<DefaultProperty> newSettings;
    protected PlanType plan;

    public PlanSettingsChanged(PlanType plan, Collection<DefaultProperty> newSettings, LinkedHashMap<String, Vector<DefaultProperty>> previousSettings) {
        this.plan = plan;
        this.newSettings = newSettings;
        this.previousSettings = previousSettings;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        Vector<String> settings = new Vector<String>();
        for (DefaultProperty p : this.newSettings) {
            settings.add(p.getDisplayName());
        }
        return I18n.textf("Change %planSettings in the entire plan.", StringUtils.join(settings, (String)", "));
    }

    @Override
    public void undo() throws CannotUndoException {
        for (String key : this.previousSettings.keySet()) {
            this.plan.getGraph().getManeuver(key).setProperties((Property[])this.previousSettings.get(key).toArray(new DefaultProperty[0]));
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        for (Maneuver m : this.plan.getGraph().getAllManeuvers()) {
            m.setProperties((Property[])this.newSettings.toArray(new DefaultProperty[0]));
        }
    }

    public PlanType getPlan() {
        return this.plan;
    }
}

