/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.edit;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanTranslated
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected PlanType plan;
    protected double deltaEast;
    protected double deltaNorth;

    public PlanTranslated(PlanType plan, double deltaEast, double deltaNorth) {
        this.plan = plan;
        this.deltaEast = deltaEast;
        this.deltaNorth = deltaNorth;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return I18n.text("Move the entire plan");
    }

    @Override
    public void undo() throws CannotUndoException {
        for (Maneuver man : this.plan.getGraph().getAllManeuvers()) {
            if (man == null || !(man instanceof LocatedManeuver)) continue;
            ((LocatedManeuver)((Object)man)).translate(-this.deltaNorth, -this.deltaEast, 0.0);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        for (Maneuver man : this.plan.getGraph().getAllManeuvers()) {
            if (man == null || !(man instanceof LocatedManeuver)) continue;
            ((LocatedManeuver)((Object)man)).translate(this.deltaNorth, this.deltaEast, 0.0);
        }
    }

    public PlanType getPlan() {
        return this.plan;
    }
}

