/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.edit;

import java.util.LinkedHashMap;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanZChanged
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected LinkedHashMap<String, ManeuverLocation.Z_UNITS> previousUnits;
    protected LinkedHashMap<String, Double> previousValues;
    protected double newZ;
    protected ManeuverLocation.Z_UNITS newUnits;
    protected PlanType plan;

    public PlanZChanged(PlanType plan, double newZ, ManeuverLocation.Z_UNITS newUnits, LinkedHashMap<String, ManeuverLocation.Z_UNITS> previousUnits, LinkedHashMap<String, Double> previousValues) {
        this.plan = plan;
        this.newZ = newZ;
        this.newUnits = newUnits;
        this.previousUnits = previousUnits;
        this.previousValues = previousValues;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return I18n.textf("Set %zunits of %newValue in the entire plan.", this.newUnits.name(), this.newZ);
    }

    @Override
    public void undo() throws CannotUndoException {
        for (String key : this.previousUnits.keySet()) {
            LocatedManeuver man = (LocatedManeuver)((Object)this.plan.getGraph().getManeuver(key));
            ManeuverLocation loc = man.getManeuverLocation();
            loc.setZ(this.previousValues.get(key));
            loc.setZUnits(this.previousUnits.get(key));
            man.setManeuverLocation(loc);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        for (Maneuver m : this.plan.getGraph().getAllManeuvers()) {
            if (!(m instanceof LocatedManeuver)) continue;
            LocatedManeuver man = (LocatedManeuver)((Object)m);
            ManeuverLocation loc = man.getManeuverLocation();
            loc.setZ(this.newZ);
            loc.setZUnits(this.newUnits);
            man.setManeuverLocation(loc);
        }
    }

    public PlanType getPlan() {
        return this.plan;
    }
}

