/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.plandb;

import java.util.Vector;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.plugins.planning.plandb.IPlanDBListener;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBInfo;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBState;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanDBControl
implements MessageListener<MessageInfo, IMCMessage> {
    protected String remoteSystemId = null;
    protected PlanDBState remoteState = null;
    protected final int planDB_id = IMCDefinition.getInstance().getMessageId("PlanDB");
    protected Vector<IPlanDBListener> listeners = new Vector();

    public boolean addListener(IPlanDBListener listener) {
        if (!this.listeners.contains(listener)) {
            return this.listeners.add(listener);
        }
        return false;
    }

    public boolean removeListener(IPlanDBListener listener) {
        return this.listeners.remove(listener);
    }

    public String getRemoteSystemId() {
        return this.remoteSystemId;
    }

    public void setRemoteSystemId(String remoteSystemId) {
        if (this.remoteState == null || this.remoteSystemId == null || !remoteSystemId.equals(this.remoteSystemId)) {
            this.remoteState = new PlanDBState();
        }
        this.remoteSystemId = remoteSystemId;
    }

    public PlanDBState getRemoteState() {
        return this.remoteState;
    }

    public boolean clearDatabase() {
        IMCMessage imc_PlanDB = IMCDefinition.getInstance().create("PlanDB", new Object[]{"type", "REQUEST", "op", "CLEAR", "request_id", IMCSendMessageUtils.getNextRequestId()});
        return ImcMsgManager.getManager().sendMessageToSystem(imc_PlanDB, this.remoteSystemId);
    }

    public boolean sendPlan(PlanType plan) {
        IMCMessage imc_PlanDB = IMCDefinition.getInstance().create("PlanDB", new Object[]{"type", "REQUEST", "op", "SET", "request_id", IMCSendMessageUtils.getNextRequestId(), "plan_id", plan.getId(), "arg", plan.asIMCPlan(), "info", ""});
        return ImcMsgManager.getManager().sendMessageToSystem(imc_PlanDB, this.remoteSystemId);
    }

    public boolean requestPlan(String plan_id) {
        IMCMessage imc_PlanDB = IMCDefinition.getInstance().create("PlanDB", new Object[]{"type", "REQUEST", "op", "GET", "request_id", IMCSendMessageUtils.getNextRequestId(), "plan_id", plan_id});
        return ImcMsgManager.getManager().sendMessageToSystem(imc_PlanDB, this.remoteSystemId);
    }

    public boolean requestActivePlan() {
        return this.requestPlan(null);
    }

    public boolean requestPlanInfo(String plan_id) {
        IMCMessage imc_PlanDB = IMCDefinition.getInstance().create("PlanDB", new Object[]{"type", "REQUEST", "op", "GET_INFO", "request_id", IMCSendMessageUtils.getNextRequestId(), "plan_id", plan_id});
        return ImcMsgManager.getManager().sendMessageToSystem(imc_PlanDB, this.remoteSystemId);
    }

    public boolean deletePlan(String plan_id) {
        IMCMessage imc_PlanDB = IMCDefinition.getInstance().create("PlanDB", new Object[]{"type", "REQUEST", "op", "DEL", "request_id", IMCSendMessageUtils.getNextRequestId(), "plan_id", plan_id});
        NeptusLog.pub().debug((Object)("Sending to " + this.remoteSystemId));
        return ImcMsgManager.getManager().sendMessageToSystem(imc_PlanDB, this.remoteSystemId);
    }

    public void updateKnownState(IMCMessage imc_PlanDBState) {
        if (this.remoteState == null) {
            this.remoteState = new PlanDBState();
        }
        this.remoteState.parseIMCMessage(imc_PlanDBState);
    }

    public void onMessage(MessageInfo info, IMCMessage msg) {
        block11: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                if (msg.getMgid() != this.planDB_id) {
                                    return;
                                }
                                if (this.remoteState == null) {
                                    try {
                                        this.setRemoteSystemId(ImcSystemsHolder.lookupSystem(new ImcId16(msg.getHeaderValue("src"))).getName());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (!msg.getString("type").equals("SUCCESS")) break block11;
                                if (!msg.getString("op").equals("GET_STATE")) break block12;
                                if (this.remoteState == null) {
                                    this.remoteState = new PlanDBState();
                                }
                                this.remoteState.parseIMCMessage(msg.getMessage("arg"));
                                try {
                                    for (IPlanDBListener l : this.listeners) {
                                        l.dbInfoUpdated(this.remoteState);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break block11;
                            }
                            if (!msg.getString("op").equals("GET")) break block13;
                            PlanType pt = IMCUtils.parsePlanSpecification(new MissionType(), msg.getMessage("arg"));
                            for (IPlanDBListener l : this.listeners.toArray(new IPlanDBListener[0])) {
                                l.dbPlanReceived(pt);
                            }
                            break block11;
                        }
                        if (!msg.getString("op").equals("GET_INFO")) break block14;
                        PlanDBInfo pinfo = new PlanDBInfo();
                        pinfo.parseIMCMessage(msg.getMessage("arg"));
                        this.remoteState.storedPlans.put(msg.getAsString("plan_id"), pinfo);
                        break block11;
                    }
                    if (!msg.getString("op").equals("DEL")) break block15;
                    this.remoteState.storedPlans.remove(msg.getAsString("plan_id"));
                    for (IPlanDBListener l : this.listeners) {
                        l.dbPlanRemoved(msg.getAsString("plan_id"));
                    }
                    break block11;
                }
                if (!msg.getString("op").equals("CLEAR")) break block16;
                this.remoteState.storedPlans.clear();
                break block11;
            }
            if (!msg.getString("op").equals("SET")) break block11;
            this.requestPlanInfo(msg.getAsString("plan_id"));
            for (IPlanDBListener l : this.listeners) {
                l.dbPlanSent(msg.getAsString("plan_id"));
            }
        }
    }
}

