/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning.plandb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBInfo;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ByteUtil;

public class PlanDBState
implements IMCSerialization {
    protected long lastStateUpdated = -1L;
    protected Map<String, PlanDBInfo> storedPlans = Collections.synchronizedMap(new LinkedHashMap());
    protected byte[] md5 = null;
    protected Double lastChange = null;
    protected ImcId16 lastChangeAddr = null;
    protected String lastChangeName = null;

    @Override
    public IMCMessage serializeToIMC() {
        return null;
    }

    @Override
    public synchronized void parseIMCMessage(IMCMessage imc_PlanDBState) {
        this.lastChangeAddr = new ImcId16(imc_PlanDBState.getInteger("change_sid"));
        this.lastChangeName = imc_PlanDBState.getAsString("change_sname");
        this.md5 = imc_PlanDBState.getRawData("md5");
        Vector planInfos = imc_PlanDBState.getMessageList("plans_info");
        ArrayList<String> plansIdInVehicle = new ArrayList<String>();
        for (IMCMessage m : planInfos) {
            String planId = m.getString("plan_id");
            PlanDBInfo pinfo = !this.storedPlans.containsKey(planId) ? new PlanDBInfo() : this.storedPlans.get(planId);
            pinfo.parseIMCMessage(m);
            this.storedPlans.put(planId, pinfo);
            plansIdInVehicle.add(planId);
        }
        for (String key : this.storedPlans.keySet().toArray(new String[this.storedPlans.size()])) {
            if (plansIdInVehicle.contains(key)) continue;
            this.storedPlans.remove(key);
        }
        this.lastStateUpdated = System.currentTimeMillis();
    }

    public Map<String, PlanDBInfo> getStoredPlans() {
        return this.storedPlans;
    }

    public void setStoredPlans(LinkedHashMap<String, PlanDBInfo> storedPlans) {
        this.storedPlans = storedPlans;
    }

    public byte[] getMd5() {
        return this.md5;
    }

    public void setMd5(byte[] md5) {
        this.md5 = md5;
    }

    public long getLastStateUpdated() {
        return this.lastStateUpdated;
    }

    public Double getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(Double lastChange) {
        this.lastChange = lastChange;
    }

    public ImcId16 getLastChangeAddr() {
        return this.lastChangeAddr;
    }

    public void setLastChangeAddr(ImcId16 lastChangeAddr) {
        this.lastChangeAddr = lastChangeAddr;
    }

    public String getLastChangeName() {
        return this.lastChangeName;
    }

    public void setLastChangeName(String lastChangeName) {
        this.lastChangeName = lastChangeName;
    }

    public boolean matchesRemotePlan(PlanType localPlan) {
        if (!this.storedPlans.containsKey(localPlan.getId())) {
            return false;
        }
        byte[] localMD5 = localPlan.asIMCPlan().payloadMD5();
        byte[] remoteMD5 = this.storedPlans.get((Object)localPlan.getId()).md5;
        boolean same = ByteUtil.equal(localMD5, remoteMD5);
        return same;
    }
}

