/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.controllers;

import java.util.LinkedHashMap;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.JoyEnvironment;
import pt.lsts.neptus.NeptusLog;

public class ControllerManager {
    private LinkedHashMap<String, Controller> controllerList = new LinkedHashMap();

    public ControllerManager() {
        this.fetchControllers();
    }

    public void fetchControllers() {
        Controller[] controllers;
        LinkedHashMap<String, Controller> oldMap = new LinkedHashMap<String, Controller>();
        for (String s : this.controllerList.keySet()) {
            oldMap.put(s, this.controllerList.get(s));
        }
        this.controllerList.clear();
        for (Controller c : controllers = new JoyEnvironment().getControllers()) {
            if (c.getName().toLowerCase().contains("keyboard") || c.getName().toLowerCase().contains("mouse") || c.getType() != Controller.Type.GAMEPAD && c.getType() != Controller.Type.STICK) continue;
            this.controllerList.put(c.getName(), c);
        }
        for (String k : oldMap.keySet()) {
            if (this.controllerList.containsKey(k)) continue;
            NeptusLog.pub().info((Object)("Removed " + ((Controller)oldMap.get(k)).getName()));
        }
        for (String k : this.controllerList.keySet()) {
            if (oldMap.containsKey(k)) continue;
            NeptusLog.pub().info((Object)("Added " + this.controllerList.get(k).getName()));
        }
    }

    public LinkedHashMap<String, Component> pollController(Controller c) {
        LinkedHashMap<String, Component> pollResult = new LinkedHashMap<String, Component>();
        if (!c.poll()) {
            return null;
        }
        for (Component comp : c.getComponents()) {
            pollResult.put(comp.getName(), comp);
        }
        return pollResult;
    }

    public LinkedHashMap<String, Component> pollController(String device) {
        Controller c = this.controllerList.get(device);
        return this.pollController(c);
    }

    public LinkedHashMap<String, Controller> getControllerList() {
        return this.controllerList;
    }
}

