/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.controllers;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.java.games.input.Component;
import net.miginfocom.swing.MigLayout;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.RemoteActions;
import pt.lsts.imc.RemoteActionsRequest;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.controllers.ControllerManager;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;

@Popup(pos=Popup.POSITION.TOP_RIGHT, width=200, height=400, accelerator=74)
@PluginDescription(author="jquadrado", description="Controllers Panel", name="Controllers Panel", icon="images/control-mode/teleoperation.png")
public class ControllerPanel
extends ConsolePanel
implements IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_FILE_XML = "conf/controllers/actions.xml";
    private boolean sending = false;
    private LinkedHashMap<String, String> actions = new LinkedHashMap();
    private ArrayList<MapperComponent> mappedActions = new ArrayList();
    private LinkedHashMap<String, String> msgActions = new LinkedHashMap();
    private LinkedHashMap<String, Component> poll;
    private ArrayList<JComboBox<String>> controllerSelectors = new ArrayList();
    private JTable table = new JTable(){

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column != 3) {
                return ControllerPanel.this.renderer;
            }
            return super.getCellRenderer(row, column);
        }
    };
    private AbstractTableModel model;
    private TableRenderer renderer = new TableRenderer();
    private ControllerManager manager;
    private JButton btnRefresh = new JButton(new AbstractAction(I18n.text("Refresh Controllers")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ControllerPanel.this.updateControllers();
        }
    });
    private int timeIncrement = 0;
    private int periodicDelay = 100;
    private String currentController;
    private Document doc;
    private ConsoleLayout console;
    private boolean editing = false;
    private LinkedHashMap<String, Float> oldPoll = new LinkedHashMap();

    public ControllerPanel(ConsoleLayout console) {
        super(console);
        this.console = console;
        this.removeAll();
        console.addMainVehicleListener(this);
        PeriodicUpdatesService.register(this);
        this.getConsole().getImcMsgManager().addListener(this);
    }

    @Override
    public void initSubPanel() {
        SAXReader reader = new SAXReader();
        File fx = new File(ACTION_FILE_XML);
        if (fx.exists()) {
            try {
                this.doc = reader.read(fx);
            }
            catch (DocumentException e) {
                this.doc = DocumentHelper.createDocument();
                NeptusLog.pub().warn((Object)"Error loading controller actions file! Creating a new file.", (Throwable)e);
            }
        } else {
            this.doc = DocumentHelper.createDocument();
        }
        this.manager = this.console.getControllerManager();
        this.controllerSelectors.add(this.generateControllerSelector());
        this.controllerSelectors.add(this.generateControllerSelector());
        this.currentController = (String)this.controllerSelectors.get(0).getSelectedItem();
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ControllerPanel.this.sending = true;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ControllerPanel.this.sending = false;
            }
        });
        this.refreshInterface();
    }

    @Override
    public void cleanSubPanel() {
        this.console.removeMainVehicleListener(this);
        PeriodicUpdatesService.unregister(this);
        this.getConsole().getImcMsgManager().removeListener(this);
    }

    public void buildDialog() {
        this.removeAll();
        this.setSize(300, 200);
        this.setLayout((LayoutManager)new MigLayout());
        this.model = new TableModel(this.mappedActions);
        this.table.setModel(this.model);
        this.table.addMouseListener(new JTableButtonMouseListener(this.table));
        this.add((java.awt.Component)new JScrollPane(this.table), "wrap");
        for (JComboBox<String> selector : this.controllerSelectors) {
            this.add(selector, "w 200::, wrap");
        }
        this.add(this.btnRefresh);
        this.dialog.pack();
    }

    public JComboBox<String> generateControllerSelector() {
        JComboBox<String> comboBox = new JComboBox<String>(this.manager.getControllerList().keySet().toArray(new String[0]));
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                ControllerPanel.this.currentController = (String)cb.getSelectedItem();
                ControllerPanel.this.mappedActions = ControllerPanel.this.getMappedActions(ControllerPanel.this.console.getMainSystem(), ControllerPanel.this.currentController);
                ControllerPanel.this.buildDialog();
            }
        });
        return comboBox;
    }

    public ArrayList<MapperComponent> getMappedActions(String systemName, String controllerName) {
        ArrayList<MapperComponent> result = new ArrayList<MapperComponent>();
        for (String action : this.actions.keySet()) {
            MapperComponent comp = this.getMapperComponentByName(systemName, controllerName, action);
            if (comp == null) {
                result.add(new MapperComponent(action, "", 0.0f, false));
                continue;
            }
            result.add(comp);
        }
        return result;
    }

    public MapperComponent getMapperComponentByName(String systemName, String controllerName, String actionName) {
        List list = this.doc.selectNodes("/systems/system[@name='" + systemName + "']/controller[@name='" + controllerName + "']/*");
        for (Element el : list) {
            if (!el.attributeValue("action").equalsIgnoreCase(actionName)) continue;
            return new MapperComponent(el.attributeValue("action"), el.attributeValue("component"), 0.0f, Boolean.parseBoolean(el.attributeValue("inverted")));
        }
        return null;
    }

    public void requestRemoteActions() {
        if (this.console.getMainSystem() != null) {
            RemoteActionsRequest msg = RemoteActionsRequest.create((Object[])new Object[]{"op", 1});
            ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)msg, this.console.getMainSystem());
        }
    }

    public void updateControllers() {
        this.manager.fetchControllers();
        String[] list = this.manager.getControllerList().keySet().toArray(new String[0]);
        for (JComboBox<String> cb : this.controllerSelectors) {
            cb.removeAllItems();
            for (String s : list) {
                cb.addItem(s);
            }
        }
    }

    public void refreshInterface() {
        this.actions = null;
        this.removeAll();
        if (this.console.getMainSystem() != null) {
            this.add(new JLabel(I18n.text("Waiting for vehicle action list")));
        } else {
            this.add(new JLabel(I18n.text("No main vehicle selected in the console")));
        }
        this.invalidate();
        this.revalidate();
        this.requestRemoteActions();
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange evt) {
        this.refreshInterface();
    }

    @Override
    public long millisBetweenUpdates() {
        return this.periodicDelay;
    }

    @Override
    public boolean update() {
        if (this.manager == null || this.currentController == null) {
            return true;
        }
        this.sending = this.dialog.isVisible();
        this.poll = this.manager.pollController(this.currentController);
        if (this.poll == null) {
            return true;
        }
        this.btnRefresh.setEnabled(!this.editing);
        if (this.editing) {
            if (this.oldPoll.size() == this.poll.size()) {
                block0: for (String k : this.poll.keySet()) {
                    if (this.poll.get(k).getPollData() == this.oldPoll.get(k).floatValue() || (double)Math.abs(this.poll.get(k).getPollData()) != 1.0) continue;
                    for (MapperComponent mcomp : this.mappedActions) {
                        if (!mcomp.editFlag) continue;
                        mcomp.component = k;
                        mcomp.inverted = this.poll.get(k).getPollData() < 0.0f;
                        this.model.fireTableDataChanged();
                        this.editing = false;
                        mcomp.editFlag = false;
                        this.saveMappings();
                        continue block0;
                    }
                }
            }
            this.oldPoll.clear();
            for (String k : this.poll.keySet()) {
                this.oldPoll.put(k, Float.valueOf(this.poll.get(k).getPollData()));
            }
        } else {
            if (this.timeIncrement >= 2000 && this.actions == null) {
                this.requestRemoteActions();
                this.timeIncrement = 0;
            }
            this.timeIncrement += this.periodicDelay;
            if (this.currentController == null || this.actions == null || this.console.getMainSystem() == null) {
                return true;
            }
            this.msgActions.clear();
            for (String k : this.poll.keySet()) {
                MapperComponent comp = null;
                for (MapperComponent c : this.mappedActions) {
                    if (!c.component.equals(k)) continue;
                    comp = c;
                    break;
                }
                if (comp == null) continue;
                comp.value = this.poll.get(k).getPollData() * (float)(this.actions.get(comp.action).equals("Axis") ? 127 : 1) * (float)(comp.inverted ? -1 : 1);
                ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
                if (!this.sending) continue;
                this.msgActions.put(comp.action, comp.value + "");
            }
            if (this.sending) {
                RemoteActions msg = new RemoteActions();
                msg.setActions(this.msgActions);
                ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)msg, this.console.getMainSystem());
            }
        }
        return true;
    }

    private void saveMappings() {
        try {
            Element controller;
            Element system;
            Element systems = (Element)this.doc.selectSingleNode("/systems");
            if (systems == null) {
                systems = this.doc.addElement("systems");
            }
            if ((system = (Element)systems.selectSingleNode("system[@name='" + this.console.getMainSystem() + "']")) == null) {
                NeptusLog.pub().info((Object)"Adding new system to controller mapping");
                system = systems.addElement("system").addAttribute("name", this.console.getMainSystem());
            }
            if ((controller = (Element)system.selectSingleNode("controller[@name='" + this.currentController + "']")) == null) {
                NeptusLog.pub().info((Object)"Adding new controller to controller mapping");
                controller = system.addElement("controller").addAttribute("name", this.currentController);
            }
            List l = controller.selectNodes("entry");
            for (int i = 0; i < l.size(); ++i) {
                controller.remove((Element)l.get(i));
            }
            for (MapperComponent mcomp : this.mappedActions) {
                Element e = controller.addElement("entry");
                e.addAttribute("component", mcomp.component);
                e.addAttribute("action", mcomp.action);
                e.addAttribute("inverted", String.valueOf(mcomp.inverted));
            }
            File fx = new File(ACTION_FILE_XML);
            fx.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(ACTION_FILE_XML);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(this.doc);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void consume(RemoteActionsRequest message) {
        if (this.actions == null) {
            this.actions = new LinkedHashMap();
        }
        for (String k : message.getActions().keySet()) {
            this.actions.put(k, (String)message.getActions().get(k));
        }
        this.mappedActions = this.getMappedActions(this.console.getMainSystem(), this.currentController);
        this.buildDialog();
    }

    class JTableButtonMouseListener
    implements MouseListener {
        private JTable __table;

        private void __forwardEventToButton(MouseEvent e) {
            TableColumnModel columnModel = this.__table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.__table.getRowHeight();
            if (row >= this.__table.getRowCount() || row < 0 || column >= this.__table.getColumnCount() || column < 0) {
                return;
            }
            Object value = this.__table.getValueAt(row, column);
            if (!(value instanceof JButton)) {
                return;
            }
            JButton button = (JButton)value;
            MouseEvent buttonEvent = SwingUtilities.convertMouseEvent(this.__table, e, button);
            button.dispatchEvent(buttonEvent);
            this.__table.repaint();
        }

        public JTableButtonMouseListener(JTable table) {
            this.__table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.__forwardEventToButton(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.__forwardEventToButton(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.__forwardEventToButton(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.__forwardEventToButton(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.__forwardEventToButton(e);
        }
    }

    private class TableRenderer
    extends DefaultTableCellRenderer {
        private TableRenderer() {
        }

        @Override
        public java.awt.Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            MapperComponent comp = ((TableModel)ControllerPanel.this.model).getList().get(row);
            if (comp.editFlag) {
                this.setBackground(Color.green);
            } else {
                this.setBackground(Color.white);
            }
            if (column == 4) {
                JButton b = (JButton)ControllerPanel.this.model.getValueAt(row, column);
                b.setEnabled(!ControllerPanel.this.editing);
                return (JButton)ControllerPanel.this.model.getValueAt(row, column);
            }
            if (column == 5) {
                return (JButton)ControllerPanel.this.model.getValueAt(row, column);
            }
            return this;
        }
    }

    private class TableModel
    extends AbstractTableModel {
        public ArrayList<MapperComponent> list;

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return I18n.text("Action");
                }
                case 1: {
                    return I18n.text("Component");
                }
                case 2: {
                    return I18n.text("Value");
                }
                case 3: {
                    return I18n.text("Inverted");
                }
            }
            return "";
        }

        public TableModel(ArrayList<MapperComponent> list) {
            this.list = list;
        }

        public ArrayList<MapperComponent> getList() {
            return this.list;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MapperComponent comp = this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return comp.action;
                }
                case 1: {
                    return comp.component;
                }
                case 2: {
                    return Float.valueOf(comp.value);
                }
                case 3: {
                    return comp.inverted;
                }
                case 4: {
                    return comp.edit;
                }
                case 5: {
                    return comp.clear;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3 || col == 1 || col == 4 || col == 5;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 3) {
                this.list.get((int)row).inverted = (Boolean)value;
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            Object cl = this.getValueAt(0, c);
            if (cl == null) {
                return Object.class;
            }
            return cl.getClass();
        }
    }

    class MapperComponent {
        String action;
        String component;
        float value;
        boolean inverted;
        JButton edit;
        JButton clear;
        boolean editFlag = false;

        MapperComponent(String action, String component, float value, boolean inverted) {
            this.action = action;
            this.component = component;
            this.value = value;
            this.inverted = inverted;
            this.edit = new JButton(I18n.text("Edit"));
            this.clear = new JButton(I18n.text("Clear"));
            this.edit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (!ControllerPanel.this.editing) {
                        ControllerPanel.this.editing = true;
                        MapperComponent.this.editFlag = true;
                    }
                }
            });
            this.clear.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    MapperComponent.this.component = "";
                    MapperComponent.this.inverted = false;
                }
            });
        }
    }
}

