/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.data;

import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import pt.lsts.neptus.data.Interpolator;
import pt.lsts.neptus.data.KDTree;
import pt.lsts.neptus.data.Pair;
import pt.lsts.neptus.types.coord.LocationType;

public class GeoCollection<T> {
    private KDTree data = new KDTree(2);
    private Interpolator<T> interpolator = null;
    private LocationType center = null;
    private boolean roundCoordinates = true;

    public void add(LocationType point, T value) {
        if (this.center == null) {
            this.center = new LocationType(point);
        }
        double[] coord = point.getOffsetFrom(this.center);
        if (this.roundCoordinates) {
            coord[0] = Math.round(coord[0]);
            coord[1] = Math.round(coord[1]);
        }
        this.data.insert(coord, value);
    }

    public void remove(LocationType point) {
        double[] coord = point.getOffsetFrom(this.center);
        if (this.roundCoordinates) {
            coord[0] = Math.round(coord[0]);
            coord[1] = Math.round(coord[1]);
        }
        this.data.delete(coord);
    }

    public GeoCollection(Interpolator<T> interp) {
        this.interpolator = interp;
    }

    public Vector<T> nearestN(int numberOfPoints, LocationType loc) {
        double[] coord = loc.getOffsetFrom(this.center);
        if (this.roundCoordinates) {
            coord[0] = Math.round(coord[0]);
            coord[1] = Math.round(coord[1]);
        }
        Object[] objs = this.data.nearest(coord, Math.min(numberOfPoints, this.data.m_count));
        Vector<Object> ret = new Vector<Object>();
        for (Object o : objs) {
            ret.add(o);
        }
        return ret;
    }

    public T nearest(LocationType loc) {
        return this.nearestN(1, loc).firstElement();
    }

    public T valueAt(LocationType loc) {
        if (this.interpolator == null) {
            return this.nearest(loc);
        }
        LinkedHashMap<LocationType, T> points = this.nearestNPoints(Math.min(10, this.data.m_count), loc);
        double distSum = 0.0;
        Vector values = new Vector();
        for (Map.Entry<LocationType, T> p : points.entrySet()) {
            double dist = p.getKey().getDistanceInMeters(loc);
            dist = (dist = Math.pow(dist, 2.0)) > 0.0 ? 1.0 / dist : 1.0E20;
            distSum += dist;
            values.add(new Pair<java.lang.Double, T>(dist, p.getValue()));
        }
        return this.interpolator.interpolate(distSum, values);
    }

    public Vector<T> within(LocationType loc, double distance, int maxPoints) {
        double[] pivot = loc.getOffsetFrom(this.center);
        double[] coord = loc.getOffsetFrom(this.center);
        if (this.roundCoordinates) {
            coord[0] = Math.round(coord[0]);
            coord[1] = Math.round(coord[1]);
        }
        Vector<Pair<double[], Object>> points = this.data.nearestNPoints(coord, maxPoints);
        Vector ret = new Vector();
        for (Pair<double[], Object> p : points) {
            double dist = Point2D.distance(pivot[0], pivot[1], ((double[])p.first)[0], ((double[])p.first)[1]);
            if (!(dist < distance)) continue;
            ret.add(p.second);
        }
        return ret;
    }

    public LinkedHashMap<LocationType, T> insidePoints(LocationType sw, LocationType ne, int maxPoints) {
        double[] low = sw.getOffsetFrom(this.center);
        double[] high = ne.getOffsetFrom(this.center);
        Vector<Pair<double[], Object>> points = this.data.rangePoints(low, high);
        LinkedHashMap ret = new LinkedHashMap();
        for (Pair<double[], Object> p : points) {
            LocationType loc = new LocationType(this.center);
            loc.translatePosition((double[])p.first);
            loc.convertToAbsoluteLatLonDepth();
            ret.put(loc, p.second);
        }
        return ret;
    }

    public Vector<T> inside(LocationType sw, LocationType ne, int maxPoints) {
        Vector<T> vec = new Vector<T>();
        vec.addAll(this.insidePoints(sw, ne, maxPoints).values());
        return vec;
    }

    public LinkedHashMap<LocationType, T> pointsWithin(LocationType loc, double distance, int maxPoints) {
        double[] pivot = loc.getOffsetFrom(this.center);
        double[] coord = loc.getOffsetFrom(this.center);
        if (this.roundCoordinates) {
            coord[0] = Math.round(coord[0]);
            coord[1] = Math.round(coord[1]);
        }
        Vector<Pair<double[], Object>> points = this.data.nearestNPoints(coord, maxPoints);
        LinkedHashMap ret = new LinkedHashMap();
        for (Pair<double[], Object> p : points) {
            double dist = Point2D.distance(pivot[0], pivot[1], ((double[])p.first)[0], ((double[])p.first)[1]);
            if (!(dist < distance)) continue;
            LocationType l = new LocationType(this.center);
            l.translatePosition((double[])p.first);
            l.convertToAbsoluteLatLonDepth();
            ret.put(l, p.second);
        }
        return ret;
    }

    public LinkedHashMap<LocationType, T> nearestNPoints(int numberOfPoints, LocationType loc) {
        Vector<Pair<double[], Object>> res = this.data.nearestNPoints(loc.getOffsetFrom(this.center), numberOfPoints);
        LinkedHashMap ret = new LinkedHashMap();
        for (Pair<double[], Object> pair : res) {
            LocationType l = new LocationType(this.center);
            l.translatePosition((double[])pair.first);
            ret.put(l, pair.second);
        }
        return ret;
    }

    public static void main(String[] args) {
        Random r = new Random(System.currentTimeMillis());
        Double col = new Double();
        long start = System.currentTimeMillis();
        for (double i = 0.0; i < 1000000.0; i += 1.0) {
            double val = 40.5 + r.nextDouble();
            col.add(new LocationType(val, r.nextDouble() - 8.5), val * 10.0);
        }
        System.out.println("Insertion took " + (System.currentTimeMillis() - start) + " milliseconds");
        start = System.currentTimeMillis();
        System.out.println(col.valueAt(new LocationType(41.23, -8.0)));
        System.out.println("Calculation took " + (System.currentTimeMillis() - start) + " milliseconds");
        VectorialDouble col2 = new VectorialDouble();
        start = System.currentTimeMillis();
        for (double i = 0.0; i < 1000000.0; i += 1.0) {
            double val = 40.5 + r.nextDouble();
            double val1 = 0.5 + 0.3 * r.nextDouble();
            double val2 = 90.0 + 90.0 * r.nextDouble();
            Vector<java.lang.Double> vals = new Vector<java.lang.Double>();
            vals.add(val1);
            vals.add(val2);
            col2.add(new LocationType(val, r.nextDouble() - 8.5), vals);
        }
        System.out.println("Insertion took " + (System.currentTimeMillis() - start) + " milliseconds");
        start = System.currentTimeMillis();
        System.out.println(col2.valueAt(new LocationType(41.23, -8.0)));
        System.out.println("Calculation took " + (System.currentTimeMillis() - start) + " milliseconds");
    }

    public static class VectorialDouble
    extends GeoCollection<Vector<java.lang.Double>> {
        public VectorialDouble() {
            super(new Interpolator<Vector<java.lang.Double>>(){

                @Override
                public Vector<java.lang.Double> interpolate(double weightTotal, Vector<Pair<java.lang.Double, Vector<java.lang.Double>>> weightToValues) {
                    int valSize = ((Vector)weightToValues.get((int)0).second).size();
                    Vector<java.lang.Double> vals = new Vector<java.lang.Double>(valSize);
                    for (int i = 0; i < valSize; ++i) {
                        vals.add(0.0);
                    }
                    for (Pair<java.lang.Double, Vector<java.lang.Double>> p : weightToValues) {
                        for (int i = 0; i < vals.size(); ++i) {
                            vals.set(i, vals.get(i) + (java.lang.Double)p.first * (java.lang.Double)((Vector)p.second).get(i));
                        }
                    }
                    for (int i = 0; i < vals.size(); ++i) {
                        vals.set(i, vals.get(i) / weightTotal);
                    }
                    return vals;
                }
            });
        }
    }

    public static class Double
    extends GeoCollection<java.lang.Double> {
        public Double() {
            super(new Interpolator<java.lang.Double>(){

                @Override
                public java.lang.Double interpolate(double weightTotal, Vector<Pair<java.lang.Double, java.lang.Double>> weightToValues) {
                    double val = 0.0;
                    for (Pair<java.lang.Double, java.lang.Double> p : weightToValues) {
                        val += (java.lang.Double)p.first * (java.lang.Double)p.second;
                    }
                    return val / weightTotal;
                }
            });
        }
    }

    public static class Generic<X>
    extends GeoCollection<X> {
        public Generic() {
            super(new Interpolator<X>(){

                @Override
                public X interpolate(double weightTotal, Vector<Pair<java.lang.Double, X>> weightToValues) {
                    Object min = weightToValues.firstElement().second;
                    double maxWeight = (java.lang.Double)weightToValues.firstElement().first;
                    for (int i = 1; i < weightToValues.size(); ++i) {
                        if (!((java.lang.Double)weightToValues.get((int)i).first > maxWeight)) continue;
                        maxWeight = (java.lang.Double)weightToValues.get((int)i).first;
                        min = weightToValues.get((int)i).second;
                    }
                    return min;
                }
            });
        }
    }
}

