/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.data;

class HPoint {
    protected double[] coord;

    protected HPoint(int n) {
        this.coord = new double[n];
    }

    protected HPoint(double[] x) {
        this.coord = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            this.coord[i] = x[i];
        }
    }

    protected Object clone() {
        return new HPoint(this.coord);
    }

    protected boolean equals(HPoint p) {
        for (int i = 0; i < this.coord.length; ++i) {
            if (this.coord[i] == p.coord[i]) continue;
            return false;
        }
        return true;
    }

    protected static double sqrdist(HPoint x, HPoint y) {
        double dist = 0.0;
        for (int i = 0; i < x.coord.length; ++i) {
            double diff = x.coord[i] - y.coord[i];
            dist += diff * diff;
        }
        return dist;
    }

    protected static double eucdist(HPoint x, HPoint y) {
        return Math.sqrt(HPoint.sqrdist(x, y));
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.coord.length; ++i) {
            s = s + this.coord[i] + " ";
        }
        return s;
    }
}

