/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.data;

import java.util.Vector;
import pt.lsts.neptus.data.HPoint;
import pt.lsts.neptus.data.HRect;
import pt.lsts.neptus.data.KDNode;
import pt.lsts.neptus.data.NearestNeighborList;
import pt.lsts.neptus.data.Pair;

public class KDTree {
    private int m_K;
    private KDNode m_root;
    int m_count;

    public KDTree(int k) {
        this.m_K = k;
        this.m_root = null;
    }

    public void insert(double[] key, Object value) {
        if (key.length < this.m_K) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        this.m_root = KDNode.ins(new HPoint(key), value, this.m_root, 0, this.m_K);
        ++this.m_count;
    }

    public Object search(double[] key) {
        if (key.length != this.m_K) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        KDNode kd = KDNode.srch(new HPoint(key), this.m_root, this.m_K);
        return kd == null ? null : kd.v;
    }

    public void delete(double[] key) {
        if (key.length != this.m_K) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        KDNode t = KDNode.srch(new HPoint(key), this.m_root, this.m_K);
        if (t == null) {
            throw new RuntimeException("KDTree: key missing!");
        }
        t.deleted = true;
        --this.m_count;
    }

    public Object nearest(double[] key) {
        Object[] nbrs = this.nearest(key, 1);
        return nbrs[0];
    }

    public Object[] nearest(double[] key, int n) {
        if (n < 0 || n > this.m_count) {
            throw new IllegalArgumentException("Number of neighbors (" + n + ") cannot" + " be negative or greater than number of nodes (" + this.m_count + ").");
        }
        if (key.length < this.m_K) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        Object[] nbrs = new Object[n];
        NearestNeighborList nnl = new NearestNeighborList(n);
        HRect hr = HRect.infiniteHRect(key.length);
        double max_dist_sqd = Double.MAX_VALUE;
        HPoint keyp = new HPoint(key);
        KDNode.nnbr(this.m_root, keyp, hr, max_dist_sqd, 0, this.m_K, nnl);
        for (int i = 0; i < n; ++i) {
            KDNode kd = (KDNode)nnl.removeHighest();
            nbrs[n - i - 1] = kd.v;
        }
        return nbrs;
    }

    public Vector<Pair<double[], Object>> nearestNPoints(double[] key, int n) {
        Vector<Pair<double[], Object>> vec = new Vector<Pair<double[], Object>>();
        if (n < 0 || n > this.m_count) {
            throw new IllegalArgumentException("Number of neighbors (" + n + ") cannot" + " be negative or greater than number of nodes (" + this.m_count + ").");
        }
        if (key.length < this.m_K) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        NearestNeighborList nnl = new NearestNeighborList(n);
        HRect hr = HRect.infiniteHRect(key.length);
        double max_dist_sqd = Double.MAX_VALUE;
        HPoint keyp = new HPoint(key);
        KDNode.nnbr(this.m_root, keyp, hr, max_dist_sqd, 0, this.m_K, nnl);
        for (int i = 0; i < n; ++i) {
            KDNode kd = (KDNode)nnl.removeHighest();
            vec.insertElementAt(new Pair<double[], Object>(kd.k.coord, kd.v), 0);
        }
        return vec;
    }

    public Vector<Pair<double[], Object>> rangePoints(double[] lowk, double[] uppk) {
        Vector<Pair<double[], Object>> ret = new Vector<Pair<double[], Object>>();
        if (lowk.length != uppk.length) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        if (lowk.length != this.m_K) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        Vector<KDNode> v = new Vector<KDNode>();
        KDNode.rsearch(new HPoint(lowk), new HPoint(uppk), this.m_root, 0, this.m_K, v);
        for (int i = 0; i < v.size(); ++i) {
            KDNode n = v.elementAt(i);
            ret.add(new Pair<double[], Object>(n.k.coord, n.v));
        }
        return ret;
    }

    public Object[] range(double[] lowk, double[] uppk) {
        if (lowk.length != uppk.length) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        if (lowk.length != this.m_K) {
            throw new RuntimeException("KDTree: wrong key size!");
        }
        Vector<KDNode> v = new Vector<KDNode>();
        KDNode.rsearch(new HPoint(lowk), new HPoint(uppk), this.m_root, 0, this.m_K, v);
        Object[] o = new Object[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            KDNode n = v.elementAt(i);
            o[i] = n.v;
        }
        return o;
    }

    public String toString() {
        return this.m_root.toString(0);
    }
}

