/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.data;

import java.io.Serializable;

class PriorityQueue
implements Serializable {
    private double maxPriority = Double.MAX_VALUE;
    private Object[] data;
    private double[] value;
    private int count;
    private int capacity;
    public static final long serialVersionUID = 4L;

    public PriorityQueue() {
        this.init(20);
    }

    public PriorityQueue(int capacity) {
        this.init(capacity);
    }

    public PriorityQueue(int capacity, double maxPriority) {
        this.maxPriority = maxPriority;
        this.init(capacity);
    }

    private void init(int size) {
        this.capacity = size;
        this.data = new Object[this.capacity + 1];
        this.value = new double[this.capacity + 1];
        this.value[0] = this.maxPriority;
        this.data[0] = null;
    }

    public void add(Object element, double priority) {
        if (this.count++ >= this.capacity) {
            this.expandCapacity();
        }
        this.value[this.count] = priority;
        this.data[this.count] = element;
        this.bubbleUp(this.count);
    }

    public Object remove() {
        if (this.count == 0) {
            return null;
        }
        Object element = this.data[1];
        this.data[1] = this.data[this.count];
        this.value[1] = this.value[this.count];
        this.data[this.count] = null;
        this.value[this.count] = 0.0;
        --this.count;
        this.bubbleDown(1);
        return element;
    }

    public Object front() {
        return this.data[1];
    }

    public double getMaxPriority() {
        return this.value[1];
    }

    private void bubbleDown(int pos) {
        Object element = this.data[pos];
        double priority = this.value[pos];
        while (pos * 2 <= this.count) {
            int child = pos * 2;
            if (child != this.count && this.value[child] < this.value[child + 1]) {
                ++child;
            }
            if (!(priority < this.value[child])) break;
            this.value[pos] = this.value[child];
            this.data[pos] = this.data[child];
            pos = child;
        }
        this.value[pos] = priority;
        this.data[pos] = element;
    }

    private void bubbleUp(int pos) {
        Object element = this.data[pos];
        double priority = this.value[pos];
        while (this.value[pos / 2] < priority) {
            this.value[pos] = this.value[pos / 2];
            this.data[pos] = this.data[pos / 2];
            pos /= 2;
        }
        this.value[pos] = priority;
        this.data[pos] = element;
    }

    private void expandCapacity() {
        this.capacity = this.count * 2;
        Object[] elements = new Object[this.capacity + 1];
        double[] prioritys = new double[this.capacity + 1];
        System.arraycopy(this.data, 0, elements, 0, this.data.length);
        System.arraycopy(this.value, 0, prioritys, 0, this.data.length);
        this.data = elements;
        this.value = prioritys;
    }

    public void clear() {
        for (int i = 1; i < this.count; ++i) {
            this.data[i] = null;
        }
        this.count = 0;
    }

    public int length() {
        return this.count;
    }
}

