/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.doc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.doc.DocumentationProvider;
import pt.lsts.neptus.doc.DocumentationWrapper;

public class DocumentationIndexGenerator {
    protected String[] sourceFolders = new String[]{"src", "plugins-dev"};
    protected Vector<DocumentationProvider> documentationProviders = new Vector();

    protected static void findClasses(String curPackage, File dir, Vector<DocumentationProvider> result) {
        for (File f : dir.listFiles()) {
            if (f.isFile() && f.getName().endsWith(".java")) {
                String className = f.getName().substring(0, f.getName().length() - 5);
                if (curPackage.length() > 0) {
                    className = curPackage + "." + className;
                }
                NeptusLog.pub().info((Object)("<###> " + className));
                try {
                    Class<?> c = Class.forName(className);
                    DocumentationWrapper wrapper = new DocumentationWrapper(c);
                    for (Class<?> i : c.getInterfaces()) {
                        if (i != DocumentationProvider.class) continue;
                        try {
                            result.add((DocumentationWrapper)c.newInstance());
                            break;
                        }
                        catch (Exception e) {
                            System.err.println(e.getClass().getSimpleName() + " while loading " + className);
                        }
                    }
                    if (wrapper.getDocumentationFile() == null || wrapper.getDocumentationFile().length() == 0) continue;
                    result.add(wrapper);
                }
                catch (Error e) {
                    System.err.println(e.getClass().getSimpleName() + " while loading " + className);
                }
                catch (Exception e) {
                    System.err.println(e.getClass().getSimpleName() + " while loading " + className);
                }
                continue;
            }
            if (!f.isDirectory()) continue;
            if (curPackage.length() == 0) {
                DocumentationIndexGenerator.findClasses(f.getName(), f, result);
                continue;
            }
            DocumentationIndexGenerator.findClasses(curPackage + "." + f.getName(), f, result);
        }
    }

    public static void generateIndex() throws Exception {
        Vector<File> sourceFolders = new Vector<File>();
        sourceFolders.add(new File("src"));
        sourceFolders.addAll(Arrays.asList(new File("plugins-dev").listFiles()));
        Vector<DocumentationProvider> result = new Vector<DocumentationProvider>();
        for (File f : sourceFolders) {
            DocumentationIndexGenerator.findClasses("", f, result);
        }
        LinkedHashMap index = new LinkedHashMap();
        for (DocumentationProvider s : result) {
            if (!index.containsKey(s.getSectionName())) {
                index.put(s.getSectionName(), new LinkedHashMap());
            }
            ((LinkedHashMap)index.get(s.getSectionName())).put(s.getArticleTitle(), s.getDocumentationFile());
        }
        Vector sections = new Vector();
        sections.addAll(index.keySet());
        Collections.sort(sections);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File("doc/manual/index.html")));
            writer.write("<html>\n\t<head>\n\t\t<title>Neptus Help</title>\n\t\t<link rel=\"stylesheet\" href=\"./style.css\" type=\"text/css\">\n\t</head>\n\t<body>\n");
            for (String section : sections) {
                Vector articles = new Vector();
                articles.addAll(((LinkedHashMap)index.get(section)).keySet());
                Collections.sort(articles);
                writer.write("\t\t<h2>" + section + "</h2>\n\t\t<ul>");
                for (String article : articles) {
                    writer.write("\n\t\t\t<li><a href=\"" + (String)((LinkedHashMap)index.get(section)).get(article) + "\">" + article + "</a></li>");
                }
                writer.write("\n\t\t</ul>\n");
            }
            writer.write("\n\t</body>\n</html>\n");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            DocumentationIndexGenerator.generateIndex();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

