/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.doc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import pt.lsts.neptus.doc.DocumentationProvider;
import pt.lsts.neptus.doc.DocumentationWrapper;
import pt.lsts.neptus.renderer2d.WorldRenderPainter;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class DocumentationPanel
extends JPanel
implements HyperlinkListener {
    private static final long serialVersionUID = -6368710839048154767L;
    protected static DocumentationPanel instance = null;
    protected static JFrame frame = null;
    public static String docSource;
    protected JScrollPane scrollMain;
    protected JScrollPane scrollIndex;
    protected JSplitPane split;
    protected JEditorPane indexPane;
    protected JEditorPane htmlPane;
    protected JLabel title;

    public DocumentationPanel() {
        this.setLayout(new BorderLayout());
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.setBackground(Color.white);
        this.htmlPane.addHyperlinkListener(this);
        this.indexPane = new JEditorPane();
        this.indexPane.setEditable(false);
        this.indexPane.setBackground(Color.white);
        this.indexPane.addHyperlinkListener(this);
        this.split = new JSplitPane(1);
        this.scrollMain = new JScrollPane(this.htmlPane);
        this.scrollIndex = new JScrollPane(this.indexPane);
        this.split.add(this.scrollIndex);
        this.split.add(this.scrollMain);
        this.split.setDividerLocation(200);
        try {
            this.indexPane.setPage(new File("doc/manual/index.html").toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.title = new JLabel();
        this.title.setFont(new Font("Helvetica", 2, 18));
        this.add((Component)this.split, "Center");
    }

    public void setProvider(Object o) {
        if (o instanceof Class || !(o instanceof DocumentationProvider)) {
            this.setProvider(new DocumentationWrapper(o));
        } else {
            this.setProvider((DocumentationProvider)o);
        }
    }

    public void setProvider(DocumentationProvider provider) {
        this.title.setText(provider.getArticleTitle());
        try {
            this.htmlPane.setPage(docSource + provider.getDocumentationFile());
        }
        catch (Exception e) {
            this.htmlPane.setText("Unable to read file '" + docSource + "/" + provider.getDocumentationFile() + "'");
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        try {
            this.htmlPane.setPage(e.getURL());
            this.htmlPane.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static JFrame getFrame() {
        if (instance == null) {
            instance = new DocumentationPanel();
        }
        if (frame == null) {
            frame = new JFrame("Neptus Help");
            frame.setSize(800, 500);
            frame.getContentPane().add(instance);
            frame.setDefaultCloseOperation(1);
            GuiUtils.centerOnScreen(frame);
            frame.setIconImages(ConfigFetch.getIconImagesForFrames());
        }
        frame.setVisible(true);
        frame.toFront();
        return frame;
    }

    public static void showDocumentation(DocumentationProvider provider) {
        DocumentationPanel.getFrame();
        instance.setProvider(provider);
    }

    public static void showDocumentation(Class<?> c) {
        DocumentationPanel.getFrame();
        instance.setProvider(new DocumentationWrapper(c));
    }

    public static void showDocumentation(String pathToHtml) {
        DocumentationPanel.getFrame();
        try {
            DocumentationPanel.instance.htmlPane.setPage(docSource + pathToHtml);
        }
        catch (Exception e) {
            DocumentationPanel.instance.htmlPane.setText("Unable to read file '" + docSource + "/" + pathToHtml + "'");
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        DocumentationPanel.showDocumentation(WorldRenderPainter.class);
    }

    static {
        try {
            docSource = new File("doc/manual").toURI().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

