/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.doc;

import pt.lsts.neptus.doc.DocumentationProvider;
import pt.lsts.neptus.doc.NeptusDoc;
import pt.lsts.neptus.plugins.PluginDescription;

public class DocumentationWrapper
implements DocumentationProvider {
    String title;
    String filename;
    String section;

    public DocumentationWrapper(Class<?> c) {
        NeptusDoc doc = c.getAnnotation(NeptusDoc.class);
        if (doc != null) {
            this.title = doc.ArticleTitle().length() > 0 ? doc.ArticleTitle() : c.getSimpleName();
            this.filename = doc.ArticleFilename();
            this.section = doc.Section();
            return;
        }
        PluginDescription pdesc = c.getAnnotation(PluginDescription.class);
        if (pdesc != null) {
            this.title = pdesc.name();
            this.filename = pdesc.documentation();
            this.section = pdesc.category().toString();
        }
    }

    public DocumentationWrapper(Object o) {
        this(o.getClass());
    }

    @Override
    public String getArticleTitle() {
        return this.title;
    }

    @Override
    public String getDocumentationFile() {
        return this.filename;
    }

    @Override
    public String getSectionName() {
        return this.section;
    }
}

