/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.events;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.renderer2d.InteractionAdapter;

public enum NeptusEvents {
    INSTANCE;

    private EventBus eventBus;
    private EventBus mainSystemEventBus;
    private EventBus otherSystemEventBus;
    private Map<ConsoleLayout, EventBus> consoleBus = new HashMap<ConsoleLayout, EventBus>();

    private NeptusEvents() {
        ExecutorService service = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("global events handler");
                t.setDaemon(true);
                return t;
            }
        });
        this.eventBus = new AsyncEventBus((Executor)service);
        this.eventBus.register((Object)this);
        service = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("main system events handler");
                t.setDaemon(true);
                return t;
            }
        });
        this.mainSystemEventBus = new AsyncEventBus((Executor)service);
        this.mainSystemEventBus.register((Object)this);
        service = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("other system events handler");
                t.setDaemon(true);
                return t;
            }
        });
        this.otherSystemEventBus = new AsyncEventBus((Executor)service);
        this.otherSystemEventBus.register((Object)this);
    }

    public static void post(Object arg0) {
        NeptusEvents.INSTANCE.eventBus.post(arg0);
    }

    public static void post(Object arg0, ConsoleLayout console) {
        EventBus bus = NeptusEvents.INSTANCE.consoleBus.get(console);
        if (bus == null) {
            NeptusLog.pub().error((Object)("tried to post to a console bus that doesnt exist! " + console.getTitle()));
        } else {
            bus.post(arg0);
        }
    }

    public static void register(Object object) {
        NeptusEvents.INSTANCE.eventBus.register(object);
    }

    public static void register(Object object, ConsoleLayout console) {
        EventBus bus = NeptusEvents.INSTANCE.consoleBus.get(console);
        if (bus == null) {
            if (!(object instanceof InteractionAdapter)) {
                NeptusLog.pub().error((Object)("tried to register in a console bus that doesnt exist. " + ((ConsolePanel)object).getName()));
            }
        } else {
            bus.register(object);
        }
    }

    public static void unregister(Object object, ConsoleLayout console) {
        EventBus bus = NeptusEvents.INSTANCE.consoleBus.get(console);
        if (bus == null) {
            NeptusLog.pub().error((Object)"tried to unregister in a console bus that doesnt exist.");
        } else {
            try {
                bus.unregister(object);
            }
            catch (IllegalArgumentException e) {
                NeptusLog.pub().info((Object)e, (Throwable)e);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e, (Throwable)e);
            }
        }
    }

    public static void create(ConsoleLayout console) {
        ExecutorService service = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("console event bus");
                t.setDaemon(true);
                return t;
            }
        });
        AsyncEventBus newBus = new AsyncEventBus((Executor)service);
        NeptusEvents.INSTANCE.consoleBus.put(console, (EventBus)newBus);
        newBus.register((Object)INSTANCE);
    }

    public static void delete(ConsoleLayout console) {
        AsyncEventBus bus = (AsyncEventBus)NeptusEvents.INSTANCE.consoleBus.remove(console);
        bus.unregister((Object)INSTANCE);
    }

    public static void clean() {
        for (Map.Entry<ConsoleLayout, EventBus> entry : NeptusEvents.INSTANCE.consoleBus.entrySet()) {
            entry.getValue().unregister((Object)INSTANCE);
        }
        NeptusEvents.INSTANCE.consoleBus.clear();
    }

    @Subscribe
    public void onDeadEvent(DeadEvent e) {
        NeptusLog.pub().info((Object)("Dead event of type " + e.getEvent().getClass().getSimpleName() + ", sent by " + e.getSource().getClass().getSimpleName() + " has not been received by anyone."));
    }
}

