/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.fileeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pt.lsts.neptus.fileeditor.SyntaxDocument;
import pt.lsts.neptus.loader.FileHandler;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class RMFEditor
extends JPanel
implements FileHandler {
    private static final long serialVersionUID = -1121728041793256058L;
    private JPanel southPanel = null;
    private JButton saveButton = null;
    private JButton closeButton = null;
    private JLabel statusLabel = null;
    private JEditorPane rmfEditor = null;
    private String filename = null;

    public RMFEditor() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(539, 306));
        this.add((Component)this.getSouthPanel(), "South");
        this.add((Component)new JScrollPane(this.getRMFEditorPane()), "Center");
    }

    private JPanel getSouthPanel() {
        if (this.southPanel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText("");
            this.statusLabel.setHorizontalTextPosition(2);
            this.statusLabel.setPreferredSize(new Dimension(400, 14));
            this.statusLabel.setHorizontalAlignment(2);
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.southPanel = new JPanel();
            this.southPanel.setLayout(flowLayout);
            this.southPanel.add((Component)this.statusLabel, null);
            this.southPanel.add((Component)this.getCloseButton(), null);
            this.southPanel.add((Component)this.getSaveButton(), null);
        }
        return this.southPanel;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText("Save");
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RMFEditor.this.filename != null) {
                        FileUtil.saveToFile(RMFEditor.this.filename, RMFEditor.this.getRMFEditorPane().getText());
                    }
                }
            });
        }
        return this.saveButton;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
        }
        return this.closeButton;
    }

    private JEditorPane getRMFEditorPane() {
        if (this.rmfEditor == null) {
            String[] keywords1 = new String[]{"Location", "Task", "Config", "Reaction"};
            String[] keywords2 = new String[]{"Surface", "Mark", "Transponder", "cal_depth", "set", "position", "Goto", "hold", "dive", "Surface"};
            this.rmfEditor = SyntaxDocument.getCustomEditor(keywords1, keywords2, "#", "\"'");
        }
        return this.rmfEditor;
    }

    public void setText(String text) {
        this.getRMFEditorPane().setText(text);
    }

    public void editFile(String filename) {
        this.filename = filename;
        String txt = FileUtil.getFileAsString(filename);
        this.setText(txt);
    }

    @Override
    public void handleFile(File f) {
        final JFrame frame = new JFrame("RMF Editor - " + f.getName());
        final String filename = f.getAbsolutePath();
        this.statusLabel.setText(filename);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RMFEditor.this.setVisible(false);
                frame.dispose();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = RMFEditor.this.getRMFEditorPane().getText();
                if (FileUtil.saveToFile(filename, text)) {
                    GuiUtils.infoMessage(frame, "Success", "Contents have been saved to " + filename);
                } else {
                    GuiUtils.infoMessage(frame, "Error", "Unable to save contents to " + filename);
                }
            }
        });
        this.editFile(f.getAbsolutePath());
        frame.setContentPane(this);
        frame.setSize(600, 400);
        frame.setIconImage(ImageUtils.getImage("images/neptus-icon.png"));
        GuiUtils.centerOnScreen(frame);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        RMFEditor ed = new RMFEditor();
        ed.handleFile(new File("c:/mission.rmf"));
    }
}

