/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.fileeditor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import org.apache.batik.util.gui.xmleditor.XMLEditorKit;
import org.apache.batik.util.gui.xmleditor.XMLTextEditor;
import pt.lsts.neptus.types.coord.CoordinateUtil;

public class SyntaxDocument
extends DefaultStyledDocument {
    private DefaultStyledDocument doc = this;
    private Element rootElement = this.doc.getDefaultRootElement();
    private boolean multiLineComment;
    private MutableAttributeSet normal;
    private MutableAttributeSet keyword1;
    private MutableAttributeSet keyword2;
    private MutableAttributeSet latlon;
    private MutableAttributeSet numeric;
    private MutableAttributeSet comment;
    private MutableAttributeSet quote;
    private HashSet<String> keywords1;
    private HashSet<String> keywords2;
    private String lineComment = "//";
    private String multilineCommentStart = "/*";
    private String multilineCommentEnd = "*/";
    private String quoteDelimiters = "\"'";
    private String delimiters = ";:{}()[]+-/%<=>!&|^~*";

    public static JEditorPane getJavaEditorPane() {
        StyledEditorKit javaEditor = new StyledEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return new SyntaxDocument();
            }
        };
        JEditorPane editor = new JEditorPane("text/java", "");
        editor.setEditorKit(javaEditor);
        return editor;
    }

    public static JEditorPane getJavaScriptEditorPane() {
        return SyntaxDocument.getCustomEditor(new String[]{"abstract", "boolean", "break", "byte", "byvalue", "case", "cast", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "future", "generic", "goto", "if", "implements", "import", "inner", "instanceof", "int", "interface", "long", "native", "new", "null", "operator", "outer", "package", "private", "protected", "public", "rest", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "volatile", "while"}, new String[]{"#USE", "#ENV", "out.println", "err.println", "tree", "tree.setValue", "tree.getValue", "tree.getValueAsString", "tree.getValueAsInteger", "tree.getValueAsDouble", "msg", "msg.setMsg", "msg.getMsg", "env", "env.setEnv", "env.getEnv", "env.initEnv", "env.removeEnv", "env.getEnvAsString", "env.getEnvAsInteger", "env.getEnvAsDouble"}, "//", "\"'");
    }

    public static JEditorPane getXmlEditorPane() {
        XMLEditorKit editorKit = new XMLEditorKit();
        editorKit.getStylePreferences().setSyntaxForeground((Map)new HashMap<String, Color>(){
            {
                this.put("default", Color.BLACK);
                this.put("xml_declaration", new Color(0, 128, 128));
                this.put("doctype", new Color(0, 0, 124));
                this.put("comment", new Color(128, 128, 128));
                this.put("element", new Color(128, 0, 0));
                this.put("character_data", Color.BLACK);
                this.put("attribute_name", new Color(255, 0, 0));
                this.put("attribute_value", new Color(0, 0, 124));
                this.put("cdata", new Color(0, 0, 255));
            }
        });
        XMLTextEditor editor = new XMLTextEditor();
        editor.setEditorKitForContentType("text/xml", (EditorKit)editorKit);
        editor.setContentType("text/xml");
        editor.getInputMap().put(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard");
        editor.getInputMap().put(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard");
        editor.getInputMap().put(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard");
        DefaultEditorKit.InsertContentAction ica = new DefaultEditorKit.InsertContentAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextComponent target = this.getTextComponent(e);
                if (target != null && e != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        UIManager.getLookAndFeel().provideErrorFeedback(target);
                        return;
                    }
                    String content = "    ";
                    target.replaceSelection(content);
                }
            }
        };
        editor.getInputMap().remove(KeyStroke.getKeyStroke(9, 0));
        editor.getInputMap().put(KeyStroke.getKeyStroke(9, 0), ica);
        return editor;
    }

    public static JEditorPane getCustomEditor(String[] keywords1, String[] keywords2, String startLineComment, String strDelimiters) {
        final SyntaxDocument doc = new SyntaxDocument(keywords1, keywords2);
        doc.setLineComment(startLineComment);
        doc.setQuoteDelimiters(strDelimiters);
        StyledEditorKit customEditor = new StyledEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return doc;
            }
        };
        JEditorPane editor = new JEditorPane("text/plain", "");
        ((EditorKit)customEditor).install(editor);
        editor.setEditorKit(customEditor);
        editor.getInputMap().put(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard");
        editor.getInputMap().put(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard");
        editor.getInputMap().put(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard");
        DefaultEditorKit.InsertContentAction ica = new DefaultEditorKit.InsertContentAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextComponent target = this.getTextComponent(e);
                if (target != null && e != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        UIManager.getLookAndFeel().provideErrorFeedback(target);
                        return;
                    }
                    String content = "   ";
                    if (content != null) {
                        target.replaceSelection(content);
                    }
                }
            }
        };
        editor.getInputMap().remove(KeyStroke.getKeyStroke(9, 0));
        editor.getInputMap().put(KeyStroke.getKeyStroke(9, 0), ica);
        return editor;
    }

    public SyntaxDocument() {
        this(new String[]{"abstract", "boolean", "break", "byte", "byvalue", "case", "cast", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "future", "generic", "goto", "if", "implements", "import", "inner", "instanceof", "int", "interface", "long", "native", "new", "null", "operator", "outer", "package", "private", "protected", "public", "rest", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "volatile", "while"});
    }

    public SyntaxDocument(String[] words) {
        this(words, new String[0]);
    }

    public SyntaxDocument(String[] words1, String[] words2) {
        this.putProperty("__EndOfLine__", "\n");
        this.normal = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normal, Color.black);
        this.comment = new SimpleAttributeSet();
        StyleConstants.setForeground(this.comment, Color.gray);
        StyleConstants.setItalic(this.comment, true);
        this.keyword1 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword1, Color.blue);
        this.keyword2 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword2, new Color(150, 0, 170));
        StyleConstants.setBold(this.keyword2, true);
        this.latlon = new SimpleAttributeSet();
        StyleConstants.setForeground(this.latlon, new Color(0, 150, 50));
        this.numeric = new SimpleAttributeSet();
        StyleConstants.setForeground(this.numeric, new Color(10, 150, 190));
        this.quote = new SimpleAttributeSet();
        StyleConstants.setForeground(this.quote, new Color(10, 150, 90));
        this.keywords1 = new HashSet();
        for (String k1 : words1) {
            this.keywords1.add(k1);
        }
        this.keywords2 = new HashSet();
        for (String k2 : words2) {
            this.keywords2.add(k2);
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        int offset = this.rootElement.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, this.comment, false);
        return true;
    }

    private void commentLinesAfter(String content, int line) {
        int offset = this.rootElement.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.doc.setCharacterAttributes(offset, endDelimiter - offset + 1, this.comment, false);
        }
    }

    private void highlightLinesAfter(String content, int line) throws BadLocationException {
        int delimiter;
        int offset = this.rootElement.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.rootElement.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this.rootElement.getElement(i);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(this.comment)) continue;
            this.applyHighlighting(content, i);
        }
    }

    private void applyHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.doc.setCharacterAttributes(startOffset, endOffset - startOffset + 1, this.comment, false);
            return;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, this.comment, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean value) {
        this.multiLineComment = value;
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this.quote, false);
        return endOfQuote + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        if (this.isKeyword1(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword1, false);
            return endOfToken + 1;
        }
        if (this.isKeyword2(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword2, false);
            return endOfToken + 1;
        }
        if (this.isLatLon(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.latlon, false);
            return endOfToken + 1;
        }
        if (this.isNumeric(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.numeric, false);
            return endOfToken + 1;
        }
        return endOfToken + 1;
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character) {
        return Character.isWhitespace(character.charAt(0)) || this.delimiters.indexOf(character) != -1;
    }

    protected boolean isQuoteDelimiter(String character) {
        return this.quoteDelimiters.indexOf(character) >= 0;
    }

    protected boolean isKeyword1(String token) {
        return this.keywords1.contains(token);
    }

    protected boolean isKeyword2(String token) {
        return this.keywords2.contains(token);
    }

    protected boolean isLatLon(String token) {
        return CoordinateUtil.parseLatitudeCoordToDoubleValue(token) != Double.NaN || CoordinateUtil.parseLongitudeCoordToDoubleValue(token) != Double.NaN;
    }

    protected boolean isNumeric(String token) {
        try {
            Double.parseDouble(token);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected String getStartDelimiter() {
        return this.getMultilineCommentStart();
    }

    protected String getEndDelimiter() {
        return this.getMultilineCommentEnd();
    }

    protected String getSingleLineDelimiter() {
        return this.getLineComment();
    }

    protected String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }

    protected String addMatchingBrace(int offset) throws BadLocationException {
        String temp;
        StringBuffer whiteSpace = new StringBuffer();
        int line = this.rootElement.getElementIndex(offset);
        int i = this.rootElement.getElement(line).getStartOffset();
        while ((temp = this.doc.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        return "{\n" + whiteSpace.toString() + "\t\n" + whiteSpace.toString() + "}";
    }

    public String getLineComment() {
        return this.lineComment;
    }

    public void setLineComment(String lineComment) {
        this.lineComment = lineComment;
    }

    public String getMultilineCommentEnd() {
        return this.multilineCommentEnd;
    }

    public void setMultilineCommentEnd(String multilineCommentEnd) {
        this.multilineCommentEnd = multilineCommentEnd;
    }

    public String getMultilineCommentStart() {
        return this.multilineCommentStart;
    }

    public void setMultilineCommentStart(String multilineCommentStart) {
        this.multilineCommentStart = multilineCommentStart;
    }

    public String getQuoteDelimiters() {
        return this.quoteDelimiters;
    }

    public void setQuoteDelimiters(String quoteDelimiters) {
        this.quoteDelimiters = quoteDelimiters;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }
}

