/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.ftp;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ProgressPanel;

public class FTPProgressPanel
extends ProgressPanel {
    JLabel label;
    JButton downloadButton;
    FTPFile file;
    String sourcePath;

    public FTPProgressPanel(FTPFile file, String sourcePath, DefaultMutableTreeNode parent) {
        this.file = file;
        this.sourcePath = sourcePath;
        if (file != null) {
            this.label = new JLabel(file.getName() + " " + file.getSize());
        }
        this.add(this.label);
    }

    public String getPath() {
        return this.sourcePath;
    }

    public FTPFile getFile() {
        return this.file;
    }

    public void setSelected(boolean sel) {
        if (sel) {
            this.setBackground(Color.BLACK);
            this.label.setForeground(Color.WHITE);
        } else {
            this.label.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
        }
    }

    public void download(String destPath, FTPClient client) {
        byte[] buffer = new byte[10240];
        try {
            new File(destPath + "/" + this.sourcePath).getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(destPath + "/" + this.sourcePath);
            InputStream in = client.retrieveFileStream(this.sourcePath);
            int counter = 0;
            while (true) {
                int bytes = in.read(buffer);
                NeptusLog.pub().info((Object)("<###> " + bytes));
                if (bytes < 0) break;
                out.write(buffer, 0, bytes);
                NeptusLog.pub().info((Object)("<###> " + (counter += bytes)));
            }
            NeptusLog.pub().info((Object)"<###>Finished Transfering");
            out.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

