/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.ftp;

import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import pt.lsts.neptus.NeptusLog;

public class FtpDownloader {
    private static final int DATA_TIMEOUT_MILLIS = 15000;
    private FTPClient client;
    private FTPClientConfig conf;
    private String host;
    private int port;

    public FtpDownloader(String host, int port) throws Exception {
        this.host = host;
        this.port = port;
    }

    public void renewClient() throws SocketException, IOException {
        if (this.client != null) {
            try {
                if (this.client.isConnected()) {
                    this.client.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.client == null) {
            this.client = new FTPClient();
            this.conf = new FTPClientConfig("UNIX");
            this.client.setDataTimeout(15000);
        }
        NeptusLog.pub().warn((Object)(FtpDownloader.class.getSimpleName() + " :: " + "connecting to " + this.host + ":" + this.port));
        long t1 = System.currentTimeMillis();
        this.client.connect(this.host, this.port);
        NeptusLog.pub().warn((Object)(FtpDownloader.class.getSimpleName() + " :: " + "connected to " + this.host + ":" + this.port + " took " + (System.currentTimeMillis() - t1) + "ms"));
        this.client.configure(this.conf);
        this.client.enterLocalPassiveMode();
        this.client.login("anonymous", "");
        this.client.setFileType(2);
        this.client.setControlEncoding("UTF-8");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setHostAndPort(String host, int port) {
        if (this.host != host || this.port != port) {
            try {
                this.renewClient();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.host = host;
        this.port = port;
    }

    public LinkedHashMap<String, FTPFile> listDirectory(String path) throws Exception {
        FTPFile[] lstFiles;
        ArrayList<FTPFile> toDoList = new ArrayList<FTPFile>();
        LinkedHashMap<String, FTPFile> finalList = new LinkedHashMap<String, FTPFile>();
        if (!this.client.isConnected()) {
            try {
                this.renewClient();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((lstFiles = this.client.listFiles(new String(path.getBytes(), "ISO-8859-1"))).length == 0) {
            NeptusLog.pub().warn((Object)(FtpDownloader.class.getSimpleName() + " :: No files listing in folder '" + path + "' from " + this.host));
            return finalList;
        }
        for (FTPFile f : lstFiles) {
            if (f.isDirectory()) {
                toDoList.add(f);
                continue;
            }
            String filePath = path + (path.equals("/") ? "" : "/") + f.getName();
            finalList.put(filePath, f);
        }
        for (FTPFile f : toDoList) {
            finalList.putAll(this.listDirectory(path + "/" + f.getName()));
        }
        return finalList;
    }

    public LinkedHashMap<FTPFile, String> listLogs() throws IOException {
        FTPFile[] lstFiles;
        LinkedHashMap<FTPFile, String> list = new LinkedHashMap<FTPFile, String>();
        if (this.isConnected()) {
            try {
                this.renewClient();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((lstFiles = this.client.listFiles("/")).length == 0) {
            NeptusLog.pub().warn((Object)(FtpDownloader.class.getSimpleName() + " :: Empty listing folder '/' from " + this.host));
            return list;
        }
        for (FTPFile f : lstFiles) {
            if (!f.isDirectory()) continue;
            String workingDirectory = "/" + new String(f.getName().getBytes(), "ISO-8859-1");
            FTPFile[] files = this.client.listFiles(workingDirectory);
            if (files.length == 0) {
                NeptusLog.pub().warn((Object)(":: " + workingDirectory + " has 0 files. Deleting folder"));
                boolean deletionOfEmptyLogFolder = this.client.deleteFile(workingDirectory);
                if (!deletionOfEmptyLogFolder) {
                    NeptusLog.pub().warn((Object)(":: " + workingDirectory + " has 0 files. Fail deletion of folder"));
                }
            }
            for (FTPFile f2 : files) {
                list.put(f2, f.getName() + "/" + f2.getName());
            }
        }
        return list;
    }

    public FTPClient getClient() {
        return this.client;
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        return this.client.isConnected();
    }

    public void close() throws IOException {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public static void main(String[] args) throws Exception {
        FtpDownloader test = new FtpDownloader("10.0.10.80", 30021);
        LinkedHashMap res = new LinkedHashMap();
        System.out.println(test.getClient().getControlEncoding());
        test.getClient().setControlEncoding("UTF-8");
        test.getClient().changeWorkingDirectory("/20130730/");
        String foo = test.getClient().listFiles()[6].getName();
        System.out.println(foo + " size: " + foo.length());
        for (byte b : foo.getBytes()) {
            System.out.print(String.format("%02X", b));
        }
        System.out.println();
        String foo2 = new String(foo.getBytes(), "ISO-8859-1");
        System.out.println(foo2 + " size: " + foo2.length());
        for (byte b : foo2.getBytes()) {
            System.out.print(String.format("%02X", b));
        }
        System.out.println();
        System.out.println(test.getClient().changeWorkingDirectory(foo));
        for (FTPFile s : test.getClient().listFiles()) {
            System.out.println(s.getName());
        }
    }
}

