/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gps;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.dinopolis.gpstool.gpsinput.GPSDataProcessor;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.GPSPosition;
import org.dinopolis.gpstool.gpsinput.GPSPositionError;
import org.dinopolis.gpstool.gpsinput.GPSSerialDevice;
import org.dinopolis.gpstool.gpsinput.nmea.GPSNmeaDataProcessor;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gps.GPSListener;
import pt.lsts.neptus.gps.GPSState;
import pt.lsts.neptus.util.GuiUtils;

public class GPSConnection
implements PropertyChangeListener {
    private String serialPort = "COM1";
    private int baudRate = 9600;
    private GPSState currentGPSState;
    private GPSState lastGPSState = this.currentGPSState = new GPSState();
    private GPSDataProcessor processor = new GPSNmeaDataProcessor();
    private Vector<GPSListener> gpsListeners = new Vector();
    private boolean okPressed = false;
    private Thread logger = null;
    private Thread simulator = null;

    public GPSConnection(String serialPort, int baudRate) {
        this.serialPort = serialPort;
        this.baudRate = baudRate;
    }

    public void simulateGPS(String gpsLogFile) {
        final String logFileName = gpsLogFile;
        this.simulator = new Thread(){

            @Override
            public void run() {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(logFileName));
                    br.readLine();
                    String logString = br.readLine();
                    while (this == GPSConnection.this.simulator && logString != null) {
                        GPSConnection.this.currentGPSState = new GPSState(logString);
                        GPSConnection.this.propertyChange(new PropertyChangeEvent(this, "Simulation", null, null));
                        Thread.sleep(1000L);
                        logString = br.readLine();
                    }
                    br.close();
                }
                catch (Exception e) {
                    System.err.println("Error reading the log file " + logFileName);
                    return;
                }
            }
        };
        this.simulator.start();
    }

    public void logReceivedData(String logFile) {
        if (this.logger != null) {
            return;
        }
        final String logFileName = logFile;
        this.logger = new Thread(){

            @Override
            public void run() {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(logFileName));
                    while (this == GPSConnection.this.logger) {
                        bw.write(GPSConnection.this.currentGPSState.toLogFormattedString() + "\n");
                        Thread.sleep(1000L);
                    }
                    bw.close();
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)this, (Throwable)e);
                    return;
                }
            }
        };
        this.logger.start();
    }

    public boolean connect() {
        GPSSerialDevice gpsDevice = new GPSSerialDevice();
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("port_name", this.serialPort);
        env.put("port_speed", new Integer(this.baudRate));
        try {
            gpsDevice.init(env);
            this.processor.setGPSDevice((GPSDevice)gpsDevice);
            this.processor.open();
            this.processor.addGPSDataChangeListener((PropertyChangeListener)this);
        }
        catch (GPSException gpsException) {
            GuiUtils.errorMessage(new JFrame(), "Error connecting to GPS", gpsException.getMessage());
            NeptusLog.pub().error((Object)this, (Throwable)gpsException);
            return false;
        }
        return true;
    }

    public void disconnect() {
        try {
            if (this.simulator != null) {
                this.simulator = null;
            } else {
                if (this.logger != null) {
                    this.logger = null;
                }
                this.processor.close();
            }
        }
        catch (GPSException gpsException) {
            GuiUtils.errorMessage(new JFrame(), "Error while disconnecting from GPS", gpsException.getMessage());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int numListeners;
        Object value = evt.getNewValue();
        String name = evt.getPropertyName();
        if (name.equals("location")) {
            this.currentGPSState.setLatitude(((GPSPosition)value).getLatitude());
            this.currentGPSState.setLongitude(((GPSPosition)value).getLongitude());
        }
        if (name.equals("epe")) {
            this.currentGPSState.setEstimatedError(((GPSPositionError)value).getHorizontalError());
        }
        if (name.equals("horizontal_dop")) {
            this.currentGPSState.setHdop(((Float)value).floatValue());
        }
        if (name.equals("position_dop")) {
            this.currentGPSState.setPdop(((Float)value).floatValue());
        }
        if (name.equals("vertical_dop")) {
            this.currentGPSState.setVdop(((Float)value).floatValue());
        }
        if (name.equals("altitude")) {
            this.currentGPSState.setAltitude(((Float)value).floatValue());
        }
        if (name.equals("speed")) {
            this.currentGPSState.setSpeed(((Float)value).floatValue());
        }
        if (name.equals("number_satellites")) {
            this.currentGPSState.setNumberOfVisibleSatellites((Integer)value);
        }
        if (name.equals("heading")) {
            this.currentGPSState.setHeading(((Float)value).floatValue());
        }
        if ((numListeners = this.gpsListeners.size()) > 0) {
            for (int i = 0; i < numListeners; ++i) {
                this.gpsListeners.get(i).GPSStateChanged(this.lastGPSState, this.currentGPSState);
            }
        }
        this.lastGPSState = (GPSState)this.currentGPSState.clone();
    }

    public void addGPSListener(GPSListener listener) {
        this.gpsListeners.add(listener);
        GPSState dummyState = new GPSState();
        dummyState.setAltitude(-2.147483648E9);
        listener.GPSStateChanged(dummyState, this.currentGPSState);
    }

    public void removeGPSListener(GPSListener listener) {
        this.gpsListeners.remove(listener);
    }

    public boolean showConnectionDialog() {
        final JDialog topLevel = new JDialog((Frame)new JFrame(), "GPS connection parameters");
        JPanel params = new JPanel(new GridLayout(3, 1));
        JPanel portPanel = new JPanel();
        JPanel baudRatePanel = new JPanel();
        JPanel controlsPanel = new JPanel();
        final JTextField portField = new JTextField(this.serialPort);
        portField.setColumns(10);
        final JTextField baudRateField = new JTextField(String.valueOf(this.baudRate));
        baudRateField.setColumns(10);
        portPanel.add(new JLabel("Serial Port: "));
        portPanel.add(portField);
        baudRatePanel.add(new JLabel("Baud Rate: "));
        baudRatePanel.add(baudRateField);
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                topLevel.setVisible(false);
                topLevel.dispose();
            }
        });
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GPSConnection.this.baudRate = Integer.parseInt(baudRateField.getText());
                }
                catch (Exception c) {
                    GuiUtils.errorMessage(topLevel, "Invalid parameters", "The entered baud rate is not valid");
                    return;
                }
                GPSConnection.this.serialPort = portField.getText();
                if (GPSConnection.this.serialPort.length() == 0) {
                    GuiUtils.errorMessage(topLevel, "Invalid parameters", "The serial port field is empty");
                    return;
                }
                GPSConnection.this.okPressed = true;
                topLevel.setVisible(false);
                topLevel.dispose();
            }
        });
        controlsPanel.add(cancelBtn);
        controlsPanel.add(okBtn);
        params.add(portPanel);
        params.add(baudRatePanel);
        params.add(controlsPanel);
        topLevel.setContentPane(params);
        topLevel.pack();
        topLevel.setSize(300, 150);
        topLevel.setModal(true);
        topLevel.setAlwaysOnTop(true);
        GuiUtils.centerOnScreen(topLevel);
        topLevel.setVisible(true);
        return this.okPressed;
    }

    public GPSState getCurrentState() {
        return (GPSState)this.currentGPSState.clone();
    }

    public static void main(String[] args) throws Exception {
        GPSConnection conn = new GPSConnection("COM10", 9600);
        conn.connect();
        conn.addGPSListener(new GPSListener(){

            @Override
            public void GPSStateChanged(GPSState oldState, GPSState newState) {
                NeptusLog.pub().info((Object)("<###> " + newState.toString()));
            }
        });
    }
}

