/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gps;

import java.util.StringTokenizer;
import pt.lsts.neptus.types.coord.LocationType;

public class GPSState {
    private int numberOfVisibleSatellites;
    private double heading;
    private double altitude;
    private double latitude;
    private double longitude;
    private double estimatedError;
    private double speed;
    private double hdop;
    private double pdop;
    private double vdop;

    public GPSState(String logFormattedString) {
        StringTokenizer st = new StringTokenizer(logFormattedString, ", ");
        if (st.countTokens() <= 5) {
            System.err.println("Bad formatted log string: " + logFormattedString);
            return;
        }
        st.nextToken();
        this.setLatitude(Double.parseDouble(st.nextToken()));
        this.setLongitude(Double.parseDouble(st.nextToken()));
        this.setAltitude(Double.parseDouble(st.nextToken()));
        this.setHeading(Double.parseDouble(st.nextToken()));
    }

    public GPSState() {
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public LocationType getCurrentLocation() {
        LocationType lt = new LocationType();
        lt.setLatitudeDegs(this.getLatitude());
        lt.setLongitudeDegs(this.getLongitude());
        lt.setHeight(this.getAltitude());
        return lt;
    }

    public double getEstimatedError() {
        return this.estimatedError;
    }

    public void setEstimatedError(double estimatedError) {
        this.estimatedError = estimatedError;
    }

    public double getHdop() {
        return this.hdop;
    }

    public void setHdop(double hdop) {
        this.hdop = hdop;
    }

    public double getPdop() {
        return this.pdop;
    }

    public void setPdop(double pdop) {
        this.pdop = pdop;
    }

    public double getVdop() {
        return this.vdop;
    }

    public void setVdop(double vdop) {
        this.vdop = vdop;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public int getNumberOfVisibleSatellites() {
        return this.numberOfVisibleSatellites;
    }

    public void setNumberOfVisibleSatellites(int numberOfVisibleSatellites) {
        this.numberOfVisibleSatellites = numberOfVisibleSatellites;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public String toString() {
        return "[GPS_STATE]\nLat: " + this.getLatitude() + ", Long: " + this.getLongitude() + "\n" + "Alt: " + this.getAltitude() + ", Speed: " + this.getSpeed() + "\n" + "Heading: " + this.getHeading() + "\n" + "HDOP: " + this.getHdop() + "\n" + "NoSatellites: " + this.getNumberOfVisibleSatellites() + ", Error: " + this.getEstimatedError();
    }

    public String toLogFormattedString() {
        return "GPS_State: " + this.getLatitude() + "," + this.getLongitude() + "," + this.getAltitude() + "," + this.getHeading() + "," + this.getSpeed() + "," + this.getHdop();
    }

    protected Object clone() {
        GPSState clone = new GPSState();
        clone.setAltitude(this.getAltitude());
        clone.setLatitude(this.getLatitude());
        clone.setLongitude(this.getLongitude());
        clone.setHeading(this.getHeading());
        clone.setSpeed(this.getSpeed());
        clone.setEstimatedError(this.getEstimatedError());
        clone.setNumberOfVisibleSatellites(this.getNumberOfVisibleSatellites());
        clone.setAltitude(this.getAltitude());
        clone.setHdop(this.getHdop());
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GPSState) {
            GPSState tmp = (GPSState)obj;
            return tmp.getAltitude() == this.getAltitude() && tmp.getLatitude() == this.getLatitude() && tmp.getLatitude() == this.getLongitude() && tmp.getSpeed() == this.getSpeed() && tmp.getHeading() == this.getHeading() && tmp.getNumberOfVisibleSatellites() == this.getNumberOfVisibleSatellites() && tmp.getEstimatedError() == this.getEstimatedError() && tmp.getHdop() == this.getHdop();
        }
        return false;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }
}

