/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.graph.DefaultNode;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.graph.NeptusNodeElement;

public class DanglingEdge {
    private Point2D targetPoint = null;
    private NeptusNodeElement<?> sourceNode = null;
    private static GeneralPath arrowTip = new GeneralPath();

    public DanglingEdge(NeptusNodeElement<?> sourceNode, Point2D targetPoint) {
        this.sourceNode = sourceNode;
        this.targetPoint = targetPoint;
    }

    public void paint(Graphics2D g, NeptusGraph<?, ?> graph) {
        g.setTransform(graph.getCurrentTransform());
        if (this.sourceNode.containsPoint(this.targetPoint)) {
            g.translate(this.sourceNode.getPosition().getX(), this.sourceNode.getPosition().getY() - DefaultNode.circleRadius);
            g.draw(new Ellipse2D.Double(-12.0, -20.0, 24.0, 24.0));
            g.translate(-11, -5);
            g.rotate(1.1780972450961724);
            g.fill(arrowTip);
        }
        g.setTransform(graph.getCurrentTransform());
        g.draw(new Line2D.Double(this.sourceNode.getPosition(), this.targetPoint));
        g.translate(this.targetPoint.getX(), this.targetPoint.getY());
        double diffX = this.targetPoint.getX() - this.sourceNode.getPosition().getX();
        double diffY = this.targetPoint.getY() - this.sourceNode.getPosition().getY();
        double angle = Math.atan2(diffY, diffX);
        g.rotate(angle);
        g.translate(-7, 0);
        g.fill(arrowTip);
    }

    public NeptusNodeElement<?> getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(NeptusNodeElement<?> sourceNode) {
        this.sourceNode = sourceNode;
    }

    public Point2D getTargetPoint() {
        return this.targetPoint;
    }

    public void setTargetPoint(Point2D targetPoint) {
        this.targetPoint = targetPoint;
    }

    static {
        arrowTip.moveTo(0.0f, 0.0f);
        arrowTip.lineTo(0.0f, -4.0f);
        arrowTip.lineTo(9.0f, 0.0f);
        arrowTip.lineTo(0.0f, 4.0f);
        arrowTip.closePath();
    }
}

