/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.graph.DefaultNode;
import pt.lsts.neptus.graph.IdGenerator;
import pt.lsts.neptus.graph.NeptusEdgeElement;
import pt.lsts.neptus.graph.NeptusGraph;

public class DefaultEdge<O>
implements NeptusEdgeElement<O> {
    private static GeneralPath arrowTip = new GeneralPath();
    private static IdGenerator idGenerator;
    private int myId = idGenerator.generateId();
    private String id = this.getElementName() + "_" + this.myId;
    private String sourceNode = null;
    private String targetNode = null;
    private O object = null;
    private boolean selected = false;
    Point2D srcPt = new Point2D.Double();
    Point2D tgtPt = new Point2D.Double();

    @Override
    public String getSourceNodeID() {
        return this.sourceNode;
    }

    @Override
    public String getTargetNodeID() {
        return this.targetNode;
    }

    @Override
    public void setSourceNodeID(String sourceNodeId) {
        this.sourceNode = sourceNodeId;
    }

    @Override
    public void setTargetNodeID(String targetNodeId) {
        this.targetNode = targetNodeId;
    }

    @Override
    public String getElementName() {
        return "Edge";
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public O getUserObject() {
        return this.object;
    }

    @Override
    public void paint(Graphics2D g, NeptusGraph<?, ?> graph) {
        Graphics2D g2d = g;
        g.setColor(Color.BLACK);
        g2d.setTransform(graph.getCurrentTransform());
        if (graph.getNode(this.getSourceNodeID()) == null) {
            throw new RuntimeException("Invalid edge. The source node '" + this.getSourceNodeID() + "' does not exist");
        }
        if (graph.getNode(this.getTargetNodeID()) == null) {
            throw new RuntimeException("Invalid edge. The target node '" + this.getTargetNodeID() + "' does not exist");
        }
        this.srcPt = graph.getNode(this.getSourceNodeID()).getPosition();
        this.tgtPt = graph.getNode(this.getTargetNodeID()).getPosition();
        double diffX = this.tgtPt.getX() - this.srcPt.getX();
        double diffY = this.tgtPt.getY() - this.srcPt.getY();
        double angle = Math.atan2(diffY, diffX);
        if (this.selected) {
            g2d.setColor(Color.blue);
        }
        if (!this.getSourceNodeID().equals(this.getTargetNodeID())) {
            g2d.translate(this.srcPt.getX(), this.srcPt.getY());
            g2d.rotate(angle);
            GeneralPath gp = new GeneralPath();
            gp.moveTo(DefaultNode.circleRadius, 0.0);
            gp.quadTo(this.tgtPt.distance(this.srcPt) / 2.0, -this.tgtPt.distance(this.srcPt) / 30.0, this.tgtPt.distance(this.srcPt) - DefaultNode.circleRadius, 0.0);
            g2d.draw(gp);
            g2d.translate(this.tgtPt.distance(this.srcPt) - DefaultNode.circleRadius - 7.0, 0.0);
            g2d.fill(arrowTip);
        } else {
            g2d.translate(this.tgtPt.getX(), this.tgtPt.getY() - DefaultNode.circleRadius);
            g2d.draw(new Arc2D.Double(-12.0, -20.0, 24.0, 24.0, -50.0, 250.0, 0));
            g2d.translate(-11, -5);
            g2d.rotate(1.1780972450961724);
            g2d.fill(arrowTip);
        }
        g2d.setColor(Color.black);
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public void setUserObject(O userObject) {
        this.object = userObject;
    }

    @Override
    public DefaultProperty[] getProperties() {
        return new DefaultProperty[0];
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Properties for " + this.getID() + " edge";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    @Override
    public void setProperties(Property[] properties) {
    }

    @Override
    public boolean containsPoint(Point2D point) {
        double minDist = 5.0;
        if (this.sourceNode.equals(this.targetNode)) {
            double x = this.srcPt.getX();
            double y = this.srcPt.getY();
            Ellipse2D.Double ellis1 = new Ellipse2D.Double(-14.0 + x, -44.0 + y, 28.0, 28.0);
            Ellipse2D.Double ellis2 = new Ellipse2D.Double(-10.0 + x, -36.0 + y, 20.0, 20.0);
            return ellis1.contains(point) && !ellis2.contains(point);
        }
        double minX = Math.min(this.srcPt.getX(), this.tgtPt.getX());
        double minY = Math.min(this.srcPt.getY(), this.tgtPt.getY());
        double maxX = Math.max(this.srcPt.getX(), this.tgtPt.getX());
        double maxY = Math.max(this.srcPt.getY(), this.tgtPt.getY());
        if (point.getX() < minX || point.getX() > maxX) {
            return false;
        }
        if (point.getY() < minY || point.getY() > maxY) {
            return false;
        }
        Line2D.Double myLine = new Line2D.Double(this.srcPt, this.tgtPt);
        return myLine.ptLineDist(point) < minDist;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void cleanup() {
        idGenerator.recycleId(this.myId);
    }

    static {
        arrowTip.moveTo(0.0f, 0.0f);
        arrowTip.lineTo(0.0f, -4.0f);
        arrowTip.lineTo(9.0f, 0.0f);
        arrowTip.lineTo(0.0f, 4.0f);
        arrowTip.closePath();
        idGenerator = new IdGenerator(false);
    }
}

