/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import pt.lsts.neptus.graph.DefaultGraphFactory;
import pt.lsts.neptus.graph.GraphSelectionListener;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.graph.NeptusGraphElement;
import pt.lsts.neptus.gui.PropertiesTable;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.util.GuiUtils;

public class DefaultGraphEditor
extends JPanel
implements UndoableEditListener,
GraphSelectionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected NeptusGraph<?, ?> graph;
    private AbstractAction undoAction;
    private AbstractAction redoAction;
    private AbstractAction layoutAction;
    protected PropertiesTable propsTable = new PropertiesTable();

    public DefaultGraphEditor(NeptusGraph<?, ?> graph) {
        this.graph = graph;
        graph.setBackground(Color.white);
        graph.getUndoSupport().addUndoableEditListener(this);
        graph.addGraphSelectionListener(this);
        this.setLayout(new TableLayout(new double[][]{{-1.0, 150.0}, {32.0, -1.0}}));
        this.add((Component)new JScrollPane(graph), "0,1");
        this.add((Component)this.createToolbar(), "0,0,1,0");
        this.add((Component)this.propsTable, "1,1");
        this.propsTable.addPropertyChangeListener(this);
    }

    private JToolBar createToolbar() {
        JToolBar toolbar = new JToolBar();
        this.undoAction = new AbstractAction("Undo"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultGraphEditor.this.graph.getUndoManager().undo();
                DefaultGraphEditor.this.updateUndoRedo();
            }
        };
        this.redoAction = new AbstractAction("Redo"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultGraphEditor.this.graph.getUndoManager().redo();
                DefaultGraphEditor.this.updateUndoRedo();
            }
        };
        this.layoutAction = new AbstractAction("Layout"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultGraphEditor.this.graph.autoLayout();
                DefaultGraphEditor.this.updateUndoRedo();
            }
        };
        this.updateUndoRedo();
        toolbar.add(this.undoAction);
        toolbar.add(this.redoAction);
        toolbar.add(this.layoutAction);
        toolbar.setFloatable(false);
        return toolbar;
    }

    private void updateUndoRedo() {
        this.undoAction.setEnabled(this.graph.getUndoManager().canUndo());
        this.undoAction.putValue("ShortDescription", this.graph.getUndoManager().getUndoPresentationName());
        this.redoAction.setEnabled(this.graph.getUndoManager().canRedo());
        this.redoAction.putValue("ShortDescription", this.graph.getUndoManager().getRedoPresentationName());
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.updateUndoRedo();
    }

    @Override
    public void selectionChanged(NeptusGraphElement<?>[] selection) {
        if (selection.length == 1) {
            this.propsTable.editProperties(selection[0]);
        } else {
            this.propsTable.editProperties(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.graph.repaint();
    }

    public static void main(String[] args) {
        GuiUtils.testFrame(new DefaultGraphEditor(new NeptusGraph(new DefaultGraphFactory())), "Graph Editor");
    }
}

