/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashMap;
import pt.lsts.neptus.graph.IdGenerator;
import pt.lsts.neptus.graph.NeptusEdgeElement;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.graph.NeptusNodeElement;
import pt.lsts.neptus.gui.PropertiesEditor;

public class DefaultNode<O>
implements NeptusNodeElement<O> {
    private Point2D position = new Point2D.Double(0.0, 0.0);
    protected O object;
    public static double circleRadius = 20.0;
    private boolean initialNode = false;
    private boolean finalNode = false;
    private boolean selected = false;
    private static IdGenerator idGenerator = new IdGenerator(false);
    private int myId = idGenerator.generateId();
    private String id = this.getElementName() + this.myId;
    LinkedHashMap<String, NeptusEdgeElement<O>> outgoingEdges = new LinkedHashMap();
    LinkedHashMap<String, NeptusEdgeElement<O>> incomingEdges = new LinkedHashMap();
    private static GeneralPath arrowTip = new GeneralPath();

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D point) {
        this.position.setLocation(point);
    }

    @Override
    public String getElementName() {
        return "S";
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public O getUserObject() {
        return this.object;
    }

    @Override
    public void paint(Graphics2D g, NeptusGraph<?, ?> graph) {
        g.setTransform(graph.getCurrentTransform());
        g.translate(this.position.getX(), this.position.getY());
        if (!this.selected) {
            g.setPaint(new GradientPaint(-25.0f, -25.0f, new Color(255, 255, 255), 50.0f, 50.0f, new Color(200, 200, 250)));
        } else {
            g.setPaint(new GradientPaint(-25.0f, -25.0f, new Color(200, 230, 255), 50.0f, 50.0f, new Color(150, 150, 250)));
        }
        g.fill(new Ellipse2D.Double(-circleRadius, -circleRadius, circleRadius * 2.0, circleRadius * 2.0));
        g.setColor(Color.BLACK);
        g.draw(new Ellipse2D.Double(-circleRadius, -circleRadius, circleRadius * 2.0, circleRadius * 2.0));
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.getID(), g);
        if (bounds.getWidth() + 2.0 > circleRadius * 2.0) {
            g.scale(circleRadius * 2.0 / (bounds.getWidth() + 2.0), circleRadius * 2.0 / (bounds.getWidth() + 2.0));
        }
        g.drawString(this.toString(), (int)(-bounds.getWidth() / 2.0 + 1.0), 6);
        g.setTransform(graph.getCurrentTransform());
        g.translate(this.position.getX(), this.position.getY());
        if (this.isInitialNode()) {
            g.translate(-circleRadius - 7.0, 0.0);
            g.drawLine(-9, 0, 0, 0);
            g.drawLine(-9, -1, 0, -1);
            g.fill(arrowTip);
            g.translate(circleRadius + 7.0, 0.0);
        }
        if (this.isFinalNode()) {
            int diff = (int)(circleRadius * 0.15);
            g.draw(new Ellipse2D.Double(-circleRadius + (double)diff, -circleRadius + (double)diff, circleRadius * 2.0 - (double)(diff * 2), circleRadius * 2.0 - (double)(diff * 2)));
        }
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public void setUserObject(O userObject) {
        this.object = userObject;
    }

    @Override
    public DefaultProperty[] getProperties() {
        DefaultProperty p1 = PropertiesEditor.getPropertyInstance("ID", String.class, this.getID(), false);
        DefaultProperty p2 = PropertiesEditor.getPropertyInstance("Initial", Boolean.class, this.isInitialNode(), true);
        DefaultProperty p3 = PropertiesEditor.getPropertyInstance("Final", Boolean.class, this.isFinalNode(), true);
        return new DefaultProperty[]{p1, p2, p3};
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Properties for " + this.getID() + " node";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            if (p.getName().equals("Initial")) {
                this.setInitialNode((Boolean)p.getValue());
            }
            if (!p.getName().equals("Final")) continue;
            this.setFinalNode((Boolean)p.getValue());
        }
    }

    public boolean isFinalNode() {
        return this.finalNode;
    }

    public void setFinalNode(boolean finalNode) {
        this.finalNode = finalNode;
    }

    public boolean isInitialNode() {
        return this.initialNode;
    }

    public void setInitialNode(boolean initialNode) {
        this.initialNode = initialNode;
    }

    @Override
    public boolean containsPoint(Point2D point) {
        return this.position.distance(point) <= circleRadius;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public int getMaxX() {
        return (int)(this.getPosition().getX() + circleRadius + 2.0);
    }

    @Override
    public int getMaxY() {
        return (int)(this.getPosition().getY() + circleRadius + 2.0);
    }

    @Override
    public void cleanup() {
        idGenerator.recycleId(this.myId);
    }

    public String toString() {
        return this.getID();
    }

    @Override
    public void addIncomingEdge(NeptusEdgeElement<O> edge) {
        this.incomingEdges.put(edge.getID(), edge);
    }

    @Override
    public void addOutgoingEdge(NeptusEdgeElement<O> edge) {
        this.outgoingEdges.put(edge.getID(), edge);
    }

    @Override
    public void removeIncomingEdge(NeptusEdgeElement edge) {
        this.incomingEdges.remove(edge.getID());
    }

    @Override
    public void removeOutgoingEdge(NeptusEdgeElement edge) {
        this.outgoingEdges.remove(edge.getID());
    }

    @Override
    public LinkedHashMap<String, NeptusEdgeElement<O>> getIncomingEdges() {
        return this.incomingEdges;
    }

    @Override
    public LinkedHashMap<String, NeptusEdgeElement<O>> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    static {
        arrowTip.moveTo(0.0f, 0.0f);
        arrowTip.lineTo(0.0f, -4.0f);
        arrowTip.lineTo(9.0f, 0.0f);
        arrowTip.lineTo(0.0f, 4.0f);
        arrowTip.closePath();
    }
}

