/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import pt.lsts.neptus.graph.DanglingEdge;
import pt.lsts.neptus.graph.DefaultGraphFactory;
import pt.lsts.neptus.graph.GraphElementFactory;
import pt.lsts.neptus.graph.GraphPainter;
import pt.lsts.neptus.graph.GraphSelectionListener;
import pt.lsts.neptus.graph.NeptusEdgeElement;
import pt.lsts.neptus.graph.NeptusGraphElement;
import pt.lsts.neptus.graph.NeptusNodeElement;
import pt.lsts.neptus.graph.edit.AddEdgeEdit;
import pt.lsts.neptus.graph.edit.AddNodeEdit;
import pt.lsts.neptus.graph.edit.MoveSelectionEdit;
import pt.lsts.neptus.graph.edit.RemoveSelectionEdit;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.util.GuiUtils;

public class NeptusGraph<N extends NeptusNodeElement, E extends NeptusEdgeElement>
extends JComponent
implements UndoableEditListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -5912721048020842022L;
    protected LinkedHashMap<String, N> nodes = new LinkedHashMap();
    protected LinkedHashMap<String, E> edges = new LinkedHashMap();
    protected Vector<NeptusGraphElement<?>> selection = new Vector();
    protected GraphElementFactory<N, E> factory = null;
    protected int graphWidth = this.getWidth();
    protected int graphHeight = this.getHeight();
    protected Point2D lastMousePoint = null;
    public Point2D dragDifference = null;
    private boolean onlyOneInitialStateAllowed = false;
    private boolean loopingAllowed = true;
    private boolean cyclingAllowed = true;
    private boolean nonDeterminismAllowed = true;
    private boolean initialStateRequired = true;
    private boolean finalStateRequired = true;
    private AffineTransform currentTransform = new AffineTransform();
    private DanglingEdge danglingEdge = null;
    private UndoManager undoManager = new UndoManager();
    private UndoableEditSupport undoSupport = new UndoableEditSupport();
    private Vector<GraphSelectionListener> selectionListeners = new Vector();
    private boolean editable = true;
    private BufferedImage offscreenBuffer = null;
    private LinkedList<GraphPainter> preRenderPainters = new LinkedList();
    private LinkedList<GraphPainter> postRenderPainters = new LinkedList();
    int count = 0;

    public NeptusGraph() {
        this.setPreferredSize(new Dimension(200, 150));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.undoSupport.addUndoableEditListener(this);
    }

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.selection.clear();
    }

    public NeptusGraph(GraphElementFactory<N, E> factoryInstance) {
        this.factory = factoryInstance;
        this.setPreferredSize(new Dimension(200, 150));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.undoSupport.addUndoableEditListener(this);
    }

    public N getNode(String id) {
        return (N)((NeptusNodeElement)this.nodes.get(id));
    }

    public E getEdge(String id) {
        return (E)((NeptusEdgeElement)this.edges.get(id));
    }

    public NeptusEdgeElement<?>[] allEdges() {
        return this.edges.values().toArray(new NeptusEdgeElement[0]);
    }

    public NeptusNodeElement<?>[] allNodes() {
        return this.nodes.values().toArray(new NeptusNodeElement[0]);
    }

    public void addNode(N node) {
        if (!this.nodes.containsKey(node.getID())) {
            this.nodes.put(node.getID(), node);
        }
        if (node.getMaxX() > this.graphWidth) {
            this.graphWidth = node.getMaxX();
        }
        if (node.getMaxY() > this.graphHeight) {
            this.graphHeight = node.getMaxY();
        }
        this.setPreferredSize(new Dimension(this.graphWidth, this.graphHeight));
        this.setMinimumSize(new Dimension(this.graphWidth, this.graphHeight));
        this.repaint();
    }

    public N addNode() {
        Random rnd = new Random(System.currentTimeMillis());
        N node = this.factory.createNode();
        this.addNode(node);
        node.setPosition(new Point2D.Double(rnd.nextDouble() * (double)this.getWidth(), rnd.nextDouble() * (double)this.getHeight()));
        this.repaint();
        return node;
    }

    public E addEdge(String src, String tgt) {
        E edge = this.factory.createEdge();
        edge.setSourceNodeID(src);
        edge.setTargetNodeID(tgt);
        if (this.nodes.containsKey(src) && this.nodes.containsKey(tgt)) {
            return this.addEdge(edge);
        }
        edge.cleanup();
        this.repaint();
        return null;
    }

    public E addEdge(E edge) {
        if (this.edges.containsKey(edge.getID())) {
            System.err.println("Tried to add an invalid edge: Edge '" + edge.getID() + "' already exists!");
            return null;
        }
        if (!this.nodes.containsKey(edge.getSourceNodeID())) {
            System.err.println("Tried to add an invalid edge ('" + edge.getSourceNodeID() + "' -> '" + edge.getTargetNodeID() + "').");
            return null;
        }
        if (!this.nodes.containsKey(edge.getTargetNodeID())) {
            System.err.println("Tried to add an invalid edge ('" + edge.getSourceNodeID() + "' -> '" + edge.getTargetNodeID() + "').");
            return null;
        }
        for (String key : ((NeptusNodeElement)this.nodes.get(edge.getSourceNodeID())).getOutgoingEdges().keySet()) {
            if (!((NeptusEdgeElement)this.edges.get(key)).getTargetNodeID().equals(edge.getTargetNodeID())) continue;
            System.err.println("Edge already exists!");
            return null;
        }
        this.edges.put(edge.getID(), edge);
        ((NeptusNodeElement)this.nodes.get(edge.getSourceNodeID())).addOutgoingEdge(edge);
        ((NeptusNodeElement)this.nodes.get(edge.getTargetNodeID())).addIncomingEdge(edge);
        this.repaint();
        return edge;
    }

    @Override
    public void paint(Graphics arg0) {
        if (this.offscreenBuffer == null || this.offscreenBuffer.getWidth() < this.getWidth() || this.offscreenBuffer.getHeight() < this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        Graphics2D g = (Graphics2D)this.offscreenBuffer.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground());
        this.currentTransform = (AffineTransform)g.getTransform().clone();
        for (GraphPainter graphPainter : this.preRenderPainters) {
            graphPainter.paint(g, this);
        }
        for (NeptusEdgeElement neptusEdgeElement : this.edges.values()) {
            if (this.selection.contains(neptusEdgeElement)) continue;
            neptusEdgeElement.paint(g, this);
        }
        for (NeptusNodeElement neptusNodeElement : this.nodes.values()) {
            if (this.selection.contains(neptusNodeElement)) continue;
            neptusNodeElement.paint(g, this);
        }
        if (this.danglingEdge != null) {
            g.setColor(Color.blue);
            this.danglingEdge.paint(g, this);
            g.setColor(Color.black);
        }
        for (NeptusGraphElement neptusGraphElement : this.selection) {
            neptusGraphElement.paint(g, this);
        }
        for (GraphPainter graphPainter : this.postRenderPainters) {
            graphPainter.paint(g, this);
        }
        arg0.drawImage(this.offscreenBuffer, 0, 0, this);
    }

    protected void editSelectionProperties() {
        if (this.selection.size() == 1) {
            PropertiesEditor.editProperties(this.selection.get(0), this.isEditable());
            this.repaint();
        }
    }

    public AbstractAction[] getClickActions(MouseEvent evt) {
        Vector<AbstractAction> actions = new Vector<AbstractAction>();
        if (evt.getButton() == 3 && this.isEditable()) {
            final Point mousePosition = evt.getPoint();
            if (this.selection.size() == 1) {
                AbstractAction propsAction = new AbstractAction("Properties..."){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        NeptusGraph.this.editSelectionProperties();
                    }
                };
                actions.add(propsAction);
            }
            if (this.selection.size() == 1 && this.selection.get(0) instanceof NeptusNodeElement) {
                AbstractAction addEdge = new AbstractAction("Add Edge"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        NeptusNodeElement node = (NeptusNodeElement)NeptusGraph.this.selection.get(0);
                        NeptusGraph.this.danglingEdge = new DanglingEdge(node, mousePosition);
                    }
                };
                actions.add(addEdge);
            } else {
                AbstractAction addNodeAction = new AbstractAction("Add node"){
                    private static final long serialVersionUID = 1L;
                    Point mousePos;
                    {
                        super(x0);
                        this.mousePos = mousePosition;
                    }

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Object node = NeptusGraph.this.factory.createNode();
                        if (node == null) {
                            return;
                        }
                        node.setPosition(this.mousePos);
                        NeptusGraph.this.addNode(node);
                        NeptusGraph.this.undoSupport.postEdit(new AddNodeEdit(NeptusGraph.this, (NeptusNodeElement)node));
                    }
                };
                actions.add(addNodeAction);
            }
            if (!this.selection.isEmpty()) {
                AbstractAction removeSelecion = new AbstractAction("Remove"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        NeptusGraph.this.removeSelection();
                    }
                };
                actions.add(removeSelecion);
            }
        }
        return actions.toArray(new AbstractAction[0]);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        AbstractAction[] actions = this.getClickActions(arg0);
        if (actions.length > 0) {
            JPopupMenu popup = new JPopupMenu();
            for (AbstractAction action : this.getClickActions(arg0)) {
                popup.add(action);
            }
            popup.show(this, arg0.getX(), arg0.getY());
        }
    }

    public NeptusEdgeElement<?>[] getSelectedEdges(boolean includeReferredElements) {
        LinkedHashMap<String, NeptusEdgeElement> selectedElements = new LinkedHashMap<String, NeptusEdgeElement>();
        for (NeptusGraphElement<?> elem : this.selection) {
            if (elem instanceof NeptusNodeElement && includeReferredElements) {
                NeptusNodeElement node = (NeptusNodeElement)elem;
                selectedElements.putAll(node.getIncomingEdges());
                selectedElements.putAll(node.getOutgoingEdges());
            }
            if (!(elem instanceof NeptusEdgeElement)) continue;
            selectedElements.put(elem.getID(), (NeptusEdgeElement)elem);
        }
        return selectedElements.values().toArray(new NeptusEdgeElement[0]);
    }

    public NeptusNodeElement[] getSelectedNodes() {
        Vector<NeptusNodeElement> selectedNodes = new Vector<NeptusNodeElement>();
        for (NeptusGraphElement<?> elem : this.selection) {
            if (!(elem instanceof NeptusNodeElement)) continue;
            selectedNodes.add((NeptusNodeElement)elem);
        }
        return selectedNodes.toArray(new NeptusNodeElement[0]);
    }

    private void removeSelection() {
        this.undoSupport.postEdit(new RemoveSelectionEdit(this));
        for (NeptusGraphElement<?> elem : this.selection) {
            if (elem instanceof NeptusNodeElement && this.nodes.containsKey(elem.getID())) {
                this.removeNode(elem.getID());
            }
            if (!(elem instanceof NeptusEdgeElement) || !this.edges.containsKey(elem.getID())) continue;
            this.removeEdge(elem.getID());
        }
        this.selection.clear();
        this.repaint();
    }

    public Vector<NeptusEdgeElement> removeNode(String id) {
        Vector<NeptusEdgeElement> edgesToBeRemoved = new Vector<NeptusEdgeElement>();
        for (NeptusEdgeElement edge : this.edges.values()) {
            if (edge.getTargetNodeID().equals(id) && !edgesToBeRemoved.contains(edge)) {
                edgesToBeRemoved.add(edge);
            }
            if (!edge.getSourceNodeID().equals(id) || edgesToBeRemoved.contains(edge)) continue;
            edgesToBeRemoved.add(edge);
        }
        for (NeptusEdgeElement edge : edgesToBeRemoved) {
            edge.setSelected(false);
            this.removeEdge(edge.getID());
        }
        NeptusNodeElement node = (NeptusNodeElement)this.nodes.get(id);
        if (node != null) {
            this.nodes.remove(id);
        }
        node.setSelected(false);
        this.repaint();
        return edgesToBeRemoved;
    }

    public void removeEdge(String id) {
        NeptusEdgeElement edge = (NeptusEdgeElement)this.edges.get(id);
        if (edge == null) {
            return;
        }
        if (this.selection.contains(edge)) {
            edge.setSelected(false);
        }
        if (this.nodes.get(edge.getSourceNodeID()) != null) {
            ((NeptusNodeElement)this.nodes.get(edge.getSourceNodeID())).removeOutgoingEdge(edge);
        }
        if (this.nodes.get(edge.getTargetNodeID()) != null) {
            ((NeptusNodeElement)this.nodes.get(edge.getTargetNodeID())).removeIncomingEdge(edge);
        }
        this.edges.remove(id);
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        if (!this.isEditable()) {
            return;
        }
        if (this.selection.isEmpty()) {
            return;
        }
        if (arg0.getPoint().getX() < 0.0 || arg0.getPoint().getY() < 0.0) {
            return;
        }
        int maxX = 0;
        int maxY = 0;
        for (NeptusNodeElement node : this.nodes.values()) {
            if (node.getMaxX() > maxX) {
                maxX = node.getMaxX();
            }
            if (node.getMaxY() <= maxY) continue;
            maxY = node.getMaxY();
        }
        this.graphWidth = maxX;
        this.graphHeight = maxY;
        this.setSize(this.graphWidth, this.graphHeight);
        this.setPreferredSize(this.getSize());
        this.setMinimumSize(this.getSize());
        if (this.lastMousePoint == null) {
            this.lastMousePoint = arg0.getPoint();
            this.dragDifference = new Point2D.Double(0.0, 0.0);
            return;
        }
        double xdiff = arg0.getPoint().getX() - this.lastMousePoint.getX();
        double ydiff = arg0.getPoint().getY() - this.lastMousePoint.getY();
        this.dragDifference.setLocation(this.dragDifference.getX() + xdiff, this.dragDifference.getY() + ydiff);
        for (NeptusGraphElement<?> el : this.selection) {
            if (!(el instanceof NeptusNodeElement)) continue;
            NeptusNodeElement node = (NeptusNodeElement)el;
            node.setPosition(new Point2D.Double(node.getPosition().getX() + xdiff, node.getPosition().getY() + ydiff));
        }
        this.lastMousePoint = arg0.getPoint();
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        if (this.danglingEdge != null) {
            this.danglingEdge.setTargetPoint(arg0.getPoint());
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        boolean selectionChanged = false;
        if (arg0.getButton() == 3 && !this.selection.isEmpty()) {
            return;
        }
        Vector<NeptusNodeElement> interceptedNodes = new Vector<NeptusNodeElement>();
        Vector<NeptusEdgeElement> interceptedEdges = new Vector<NeptusEdgeElement>();
        for (NeptusGraphElement<?> neptusGraphElement : this.selection) {
            neptusGraphElement.setSelected(false);
        }
        for (NeptusNodeElement neptusNodeElement : this.nodes.values()) {
            if (!neptusNodeElement.containsPoint(arg0.getPoint())) continue;
            interceptedNodes.add(neptusNodeElement);
        }
        for (NeptusEdgeElement neptusEdgeElement : this.edges.values()) {
            if (!neptusEdgeElement.containsPoint(arg0.getPoint())) continue;
            interceptedEdges.add(neptusEdgeElement);
        }
        if (interceptedNodes.isEmpty() && interceptedEdges.isEmpty()) {
            selectionChanged = !this.selection.isEmpty();
            this.selection.clear();
        }
        if (!selectionChanged && arg0.isShiftDown()) {
            selectionChanged = true;
            for (NeptusNodeElement neptusNodeElement : interceptedNodes) {
                if (this.selection.contains(neptusNodeElement)) continue;
                this.selection.add(neptusNodeElement);
            }
            for (NeptusEdgeElement neptusEdgeElement : interceptedEdges) {
                if (this.selection.contains(neptusEdgeElement)) continue;
                this.selection.add(neptusEdgeElement);
            }
        }
        if (!(selectionChanged || arg0.isShiftDown() || !this.selection.isEmpty() && this.selection.size() <= 1)) {
            selectionChanged = true;
            if (interceptedNodes.size() >= 1) {
                NeptusNodeElement firstSelectedNode = (NeptusNodeElement)interceptedNodes.get(0);
                this.selection.clear();
                this.selection.add(firstSelectedNode);
            } else if (interceptedEdges.size() >= 1) {
                NeptusEdgeElement firstSelectedEdge = (NeptusEdgeElement)interceptedEdges.get(0);
                firstSelectedEdge.setSelected(true);
                this.selection.clear();
                this.selection.add(firstSelectedEdge);
            }
        }
        if (!selectionChanged && !arg0.isShiftDown() && this.selection.size() == 1) {
            selectionChanged = true;
            Vector elems = new Vector();
            elems.addAll(interceptedNodes);
            elems.addAll(interceptedEdges);
            if (elems.indexOf(this.selection.get(0)) == -1 || elems.size() == 1) {
                this.selection.clear();
                this.selection.add((NeptusGraphElement<?>)elems.get(0));
            } else {
                int n2 = elems.indexOf(this.selection.get(0)) + 1;
                n2 = n2 % elems.size();
                this.selection.clear();
                this.selection.add((NeptusGraphElement<?>)elems.get(n2));
                ((NeptusGraphElement)elems.get(n2)).setSelected(true);
            }
        }
        for (NeptusGraphElement<Object> neptusGraphElement : this.selection) {
            neptusGraphElement.setSelected(true);
        }
        if (selectionChanged) {
            for (GraphSelectionListener graphSelectionListener : this.selectionListeners) {
                graphSelectionListener.selectionChanged(this.selection.toArray(new NeptusGraphElement[0]));
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (this.lastMousePoint != null && !this.selection.isEmpty()) {
            this.undoSupport.postEdit(new MoveSelectionEdit(this, this.getSelectedNodes(), this.dragDifference));
        }
        this.lastMousePoint = null;
        if (this.danglingEdge != null) {
            E edge;
            N node = this.getFirstNodeUnder(this.danglingEdge.getTargetPoint());
            if (node != null && (edge = this.addEdge(this.danglingEdge.getSourceNode().getID(), node.getID())) != null) {
                this.undoSupport.postEdit(new AddEdgeEdit(this, (NeptusEdgeElement)edge));
            }
            this.danglingEdge = null;
            this.repaint();
        }
    }

    protected N getFirstNodeUnder(Point2D point) {
        for (NeptusNodeElement node : this.nodes.values()) {
            if (!node.containsPoint(point)) continue;
            return (N)node;
        }
        return null;
    }

    public AffineTransform getCurrentTransform() {
        return this.currentTransform;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.addEdit(e.getEdit());
        this.repaint();
    }

    public boolean isLoopingAllowed() {
        return this.loopingAllowed;
    }

    public void setLoopingAllowed(boolean loopingAllowed) {
        this.loopingAllowed = loopingAllowed;
    }

    public boolean isNonDeterminismAllowed() {
        return this.nonDeterminismAllowed;
    }

    public void setNonDeterminismAllowed(boolean nonDeterminismAllowed) {
        this.nonDeterminismAllowed = nonDeterminismAllowed;
    }

    public boolean isOnlyOneInitialStateAllowed() {
        return this.onlyOneInitialStateAllowed;
    }

    public void setOnlyOneInitialStateAllowed(boolean onlyOneInitialStateAllowed) {
        this.onlyOneInitialStateAllowed = onlyOneInitialStateAllowed;
    }

    public boolean isCyclingAllowed() {
        return this.cyclingAllowed;
    }

    public void setCyclingAllowed(boolean cyclingAllowed) {
        this.cyclingAllowed = cyclingAllowed;
    }

    public boolean isFinalStateRequired() {
        return this.finalStateRequired;
    }

    public void setFinalStateRequired(boolean finalStateRequired) {
        this.finalStateRequired = finalStateRequired;
    }

    public boolean isInitialStateRequired() {
        return this.initialStateRequired;
    }

    public void setInitialStateRequired(boolean initialStateRequired) {
        this.initialStateRequired = initialStateRequired;
    }

    public void addGraphSelectionListener(GraphSelectionListener listener) {
        if (!this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public void removeGraphSelectionListener(GraphSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public NeptusNodeElement[] getAllNodes() {
        return this.nodes.values().toArray(new NeptusNodeElement[0]);
    }

    public NeptusEdgeElement[] getAllEdges() {
        return this.edges.values().toArray(new NeptusEdgeElement[0]);
    }

    public static void main(String[] args) {
        DefaultGraphFactory factory = new DefaultGraphFactory();
        NeptusGraph graph = new NeptusGraph(factory);
        graph.setBackground(Color.white);
        GuiUtils.testFrame(new JScrollPane(graph), "NeptusGraph");
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }

    public GraphElementFactory<N, E> getFactory() {
        return this.factory;
    }

    public void setFactory(GraphElementFactory<N, E> factory) {
        this.factory = factory;
    }

    public void autoLayout() {
        int margin = 40;
        int incX = 80;
        int incY = 80;
        int width = Math.max(this.getWidth(), 400);
        Vector<NeptusNodeElement> visitedNodes = new Vector<NeptusNodeElement>();
        Vector<NeptusNodeElement> expandList = new Vector<NeptusNodeElement>();
        for (NeptusNodeElement node : this.nodes.values()) {
            if (node.getIncomingEdges().size() != 0) continue;
            expandList.add(node);
        }
        int curX = margin - incX;
        int curY = margin;
        while (!expandList.isEmpty()) {
            NeptusNodeElement node = (NeptusNodeElement)expandList.firstElement();
            visitedNodes.add(node);
            if (incX > 0 && (curX += incX) > width) {
                incX = -incX;
                curY += incY;
                curX += incX;
            }
            if (incX < 0 && curX < 0) {
                incX = -incX;
                curY += incY;
                curX += incX;
            }
            node.setPosition(new Point2D.Double(curX, curY));
            for (String key : node.getOutgoingEdges().keySet()) {
                NeptusEdgeElement edge = node.getOutgoingEdges().get(key);
                NeptusNodeElement tgtNode = (NeptusNodeElement)this.nodes.get(edge.getTargetNodeID());
                if (visitedNodes.contains(tgtNode)) continue;
                expandList.add(0, tgtNode);
            }
            expandList.remove(node);
            this.repaint();
        }
        this.graphWidth = 0;
        this.graphHeight = 0;
        for (NeptusNodeElement node : this.nodes.values()) {
            if (node.getMaxX() > this.graphWidth) {
                this.graphWidth = node.getMaxX();
            }
            if (node.getMaxY() > this.graphHeight) {
                this.graphHeight = node.getMaxY();
            }
            this.setPreferredSize(new Dimension(this.graphWidth, this.graphHeight));
            this.setMinimumSize(new Dimension(this.graphWidth, this.graphHeight));
        }
        this.repaint();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void addPreRenderPainter(GraphPainter painter) {
        if (!this.preRenderPainters.contains(painter)) {
            this.preRenderPainters.add(painter);
        }
    }

    public void addPostRenderPainter(GraphPainter painter) {
        if (!this.postRenderPainters.contains(painter)) {
            this.postRenderPainters.add(painter);
        }
    }

    public void removePreRenderPainter(GraphPainter painter) {
        this.preRenderPainters.remove(painter);
    }

    public void removePostRenderPainter(GraphPainter painter) {
        this.postRenderPainters.remove(painter);
    }
}

