/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import pt.lsts.neptus.graph.GraphPainter;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ImageUtils;

public class VehiclePainter
implements GraphPainter {
    private Image vehicleImage = null;
    public static int maxWidth = 200;
    public static int maxHeight = 200;
    private double scale = 1.0;
    private PlanType plan = null;

    public VehiclePainter(PlanType plan) {
        this.plan = plan;
    }

    private void createImage(ImageObserver observer) {
        try {
            this.vehicleImage = ImageUtils.getImage(this.plan.getVehicleType().getSideImageHref());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scale = Math.min(this.scale, (double)maxWidth / (double)this.vehicleImage.getWidth(null));
        this.scale = Math.min(this.scale, (double)maxHeight / (double)this.vehicleImage.getHeight(null));
        if (this.scale != 1.0) {
            this.vehicleImage = this.vehicleImage.getScaledInstance((int)((double)this.vehicleImage.getWidth(null) * this.scale), (int)((double)this.vehicleImage.getHeight(null) * this.scale), 4);
        }
    }

    @Override
    public void paint(Graphics2D g, NeptusGraph<?, ?> graph) {
        if (this.vehicleImage == null) {
            this.createImage(graph);
        }
        g.drawImage(this.vehicleImage, 0, 0, graph);
        g.setColor(new Color(255, 255, 255, 200));
        g.fillRect(0, 0, 200, 200);
    }

    @Override
    public int compareTo(GraphPainter o) {
        return 0;
    }
}

