/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph.edit;

import java.awt.geom.Point2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.graph.NeptusNodeElement;

public class MoveSelectionEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private NeptusGraph<?, ?> graph;
    private NeptusNodeElement[] movedNodes;
    private Point2D dragDifference;

    public MoveSelectionEdit(NeptusGraph<?, ?> graph, NeptusNodeElement[] movedNodes, Point2D dragDifference) {
        this.graph = graph;
        this.movedNodes = movedNodes;
        this.dragDifference = dragDifference;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() throws CannotUndoException {
        for (NeptusNodeElement node : this.movedNodes) {
            double dX = this.dragDifference.getX();
            double dY = this.dragDifference.getY();
            node.setPosition(new Point2D.Double(node.getPosition().getX() - dX, node.getPosition().getY() - dY));
        }
        this.graph.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        for (NeptusNodeElement node : this.movedNodes) {
            double dX = this.dragDifference.getX();
            double dY = this.dragDifference.getY();
            node.setPosition(new Point2D.Double(node.getPosition().getX() + dX, node.getPosition().getY() + dY));
        }
        this.graph.repaint();
    }

    @Override
    public String getPresentationName() {
        if (this.movedNodes.length == 1) {
            return "Move the node '" + this.movedNodes[0].getID() + "'";
        }
        return "Move selection";
    }
}

