/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph.edit;

import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.graph.NeptusEdgeElement;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.graph.NeptusNodeElement;

public class RemoveNodeEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private NeptusGraph<NeptusNodeElement<?>, NeptusEdgeElement<?>> graph;
    private NeptusNodeElement<?> node;
    private Vector<NeptusEdgeElement> referredEdges = new Vector();

    public RemoveNodeEdit(NeptusGraph<NeptusNodeElement<?>, NeptusEdgeElement<?>> graph, NeptusNodeElement<?> node) {
        this.graph = graph;
        this.node = node;
        this.referredEdges.addAll(node.getIncomingEdges().values());
        this.referredEdges.addAll(node.getOutgoingEdges().values());
        NeptusLog.pub().info((Object)("<###> " + this.referredEdges.size() + " edges referred"));
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() throws CannotUndoException {
        this.graph.addNode(this.node);
        for (NeptusEdgeElement edge : this.referredEdges) {
            this.graph.addEdge(edge);
        }
        this.graph.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        this.graph.removeNode(this.node.getID());
        this.graph.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Remove node '" + this.node.getID() + "'";
    }
}

