/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.graph.edit;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.graph.NeptusEdgeElement;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.graph.NeptusGraphElement;
import pt.lsts.neptus.graph.NeptusNodeElement;

public class RemoveSelectionEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private NeptusGraph<NeptusNodeElement<?>, NeptusEdgeElement<?>> graph;
    private NeptusNodeElement[] removedNodes;
    private NeptusEdgeElement[] removedEdges;

    public RemoveSelectionEdit(NeptusGraph graph) {
        this.graph = graph;
        this.removedNodes = graph.getSelectedNodes();
        this.removedEdges = graph.getSelectedEdges(true);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() throws CannotUndoException {
        for (NeptusNodeElement neptusNodeElement : this.removedNodes) {
            this.graph.addNode(neptusNodeElement);
        }
        for (NeptusGraphElement neptusGraphElement : this.removedEdges) {
            this.graph.addEdge((NeptusEdgeElement<?>)neptusGraphElement);
        }
        this.graph.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        for (NeptusNodeElement neptusNodeElement : this.removedNodes) {
            this.graph.removeNode(neptusNodeElement.getID());
        }
        for (NeptusGraphElement neptusGraphElement : this.removedEdges) {
            this.graph.removeEdge(neptusGraphElement.getID());
        }
        this.graph.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Remove various elements";
    }
}

