/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ImagePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class AboutPanel
extends JFrame {
    private static final long serialVersionUID = -6597059494859637226L;
    private static final String IMG_FILE_NAME = "images/nep-about.jpg";
    private static final String VERSION_FILE_NAME = "/version.txt";
    private static final String COPY_YEARS = "2004-2014";
    private String mainDevelopers = "Paulo Dias, Jos\u00e9 Pinto";
    private String contributersDevelopers = "Ricardo Martins, S\u00e9rgio Ferreira, Jos\u00e9 Loureiro";
    private String pastDevelopers = "Hugo Queir\u00f3s, Margarida Faria,Jos\u00e9 Correia, Hugo Dias, Rui Gon\u00e7alves, Eduardo Marques";
    private JPanel contentPanel = null;
    private ImagePanel imagePanel = null;
    private JEditorPane htmlPane = null;

    public AboutPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/neptus-icon.png")));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.WHITE);
        this.setSize(506, 542);
        this.setContentPane(this.getContentPanel());
        this.setTitle(I18n.text("About"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AboutPanel.this.dispose();
            }
        });
        this.fillText();
        GuiUtils.centerOnScreen(this);
    }

    private ImagePanel getImagePanel() {
        if (this.imagePanel == null) {
            Image image = ImageUtils.getImage(IMG_FILE_NAME);
            this.imagePanel = new ImagePanel(image);
            this.imagePanel.setPreferredSize(new Dimension(500, 264));
        }
        return this.imagePanel;
    }

    public JEditorPane getHtmlPane() {
        if (this.htmlPane == null) {
            this.htmlPane = new JEditorPane();
            this.htmlPane.setEditable(false);
            this.htmlPane.setContentType("text/html");
            this.htmlPane.setBackground(Color.WHITE);
            this.htmlPane.setForeground(Color.GRAY);
        }
        return this.htmlPane;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
            this.contentPanel.setPreferredSize(new Dimension(500, 450));
            this.contentPanel.add((Component)this.getImagePanel(), null);
            this.contentPanel.add((Component)this.getHtmlPane(), null);
        }
        return this.contentPanel;
    }

    private void fillText() {
        Properties prop = new Properties();
        String versionString = "";
        InputStream ist = this.getClass().getResourceAsStream(VERSION_FILE_NAME);
        if (ist != null) {
            try {
                prop.load(ist);
                versionString = I18n.text("Version") + " ";
                versionString = versionString + prop.getProperty("VERSION", "");
                versionString = versionString + " (";
                versionString = versionString + prop.getProperty("DATE", "");
                versionString = versionString + ", ";
                versionString = versionString + prop.getProperty("SCM_REV", "?");
                versionString = versionString + ")";
            }
            catch (IOException e) {
                NeptusLog.pub().debug((Object)this, (Throwable)e);
            }
        }
        String htmlString = "<html><head><style type=\"text/css\"><!--body {    font-family: Sans-Serif;    font-size: 11pt;    color: #808080;}.align-right {    text-align: right;}--></style></head><body><br/><b>" + I18n.text("Main Developers:") + "</b>" + "<br/>&nbsp;&nbsp;&nbsp;" + this.mainDevelopers + "<br><br>" + "<b>" + I18n.text("Contributers:") + "</b>" + "<br/>&nbsp;&nbsp;&nbsp;" + this.contributersDevelopers + "<br/><br/>" + "<b>" + I18n.text("Past Developers:") + "</b><br/>" + "&nbsp;&nbsp;&nbsp;" + this.pastDevelopers + "<br/><br/>" + "<b>" + I18n.text("Contact info:") + "</b>" + "<br/>" + "   " + I18n.text("URL:") + " http://lsts.fe.up.pt/" + "&nbsp;&nbsp;&nbsp;<br/>" + I18n.text("URL:") + " http://whale.fe.up.pt/neptus" + "<br/><br/>" + "<div class=\"align-right\">" + versionString + "<br/>" + "\u00a9 " + COPY_YEARS + " FEUP-LSTS and Developers, All Rights Reserved" + "</div>" + "</body></html>";
        this.getHtmlPane().setText(htmlString);
    }

    public static void main(String[] args) {
        new AboutPanel().setVisible(true);
    }
}

