/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.util.GuiUtils;

public class AltitudePanel
extends JPanel
implements PropertiesProvider {
    private Color backColor = Color.black;
    private Color textColor = Color.white;
    private Color thousandsPointerColor = Color.red;
    private Color hundredsPointerColor = Color.yellow;
    private int margin = 3;
    private String label = "";
    private int curValue = 0;
    Ellipse2D centerTh = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
    Ellipse2D centerHund = new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0);

    @Override
    public DefaultProperty[] getProperties() {
        return null;
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Altitude Panel Properties";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    @Override
    public void setProperties(Property[] properties) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int w = this.getWidth();
        int h = this.getHeight();
        double diameter = w < h ? (double)w : (double)h;
        double scale = diameter / 120.0;
        w = (int)((double)(w * 1) / scale);
        h = (int)((double)(h * 1) / scale);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform pre = g2d.getTransform();
        g2d.scale(scale, scale);
        diameter = w < h ? (double)w : (double)h;
        double hMargin = ((double)w - diameter) / 2.0 + (double)this.margin;
        double vMargin = ((double)h - diameter) / 2.0 + (double)this.margin;
        Ellipse2D.Double ellis = new Ellipse2D.Double(hMargin, vMargin, diameter -= (double)(this.margin * 2), diameter);
        g2d.setColor(this.backColor);
        g2d.fill(ellis);
        g2d.setColor(this.textColor);
        g2d.draw(ellis);
        double stepRotation = 0.6283185307179586;
        g2d.translate(w / 2, h / 2);
        int textMargin = 12;
        Line2D.Double stepLine = new Line2D.Double(0.0, -diameter / 2.0 + (double)this.margin + (double)textMargin, 0.0, -diameter / 2.0 + (double)this.margin + (double)textMargin + 8.0);
        for (int i = 0; i < 10; ++i) {
            g2d.draw(stepLine);
            Rectangle2D sB = g2d.getFontMetrics().getStringBounds("" + i, g2d);
            g2d.translate(0.0, -diameter / 2.0 + 7.0);
            g2d.rotate(-stepRotation * (double)i);
            g2d.drawString("" + i, (int)(-sB.getWidth()) / 2, 4);
            g2d.rotate(stepRotation * (double)i);
            g2d.translate(0.0, diameter / 2.0 - 7.0);
            g2d.rotate(stepRotation);
        }
        Line2D.Double substepLine = new Line2D.Double(0.0, -diameter / 2.0 + (double)this.margin + (double)textMargin, 0.0, -diameter / 2.0 + (double)this.margin + (double)textMargin + 4.0);
        g2d.rotate(stepRotation / 2.0);
        for (int i = 0; i < 10; ++i) {
            g2d.draw(substepLine);
            g2d.rotate(stepRotation);
        }
        g2d.rotate(-stepRotation / 2.0);
        if (this.curValue < 0) {
            this.curValue = 0;
        }
        while (this.curValue > 10000) {
            this.curValue -= 10000;
        }
        double thRotation = (double)this.curValue / 10000.0 * Math.PI * 2.0;
        g2d.rotate(thRotation);
        g2d.setColor(this.thousandsPointerColor);
        double thHeight = diameter / 2.0 - (double)this.margin - (double)textMargin;
        Polygon p = new Polygon(new int[]{-3, 3, 0}, new int[]{0, 0, -((int)thHeight)}, 3);
        g2d.fill(p);
        g2d.fill(this.centerTh);
        g2d.rotate(-thRotation);
        double hundRotation = this.curValue % 1000;
        hundRotation = hundRotation / 1000.0 * Math.PI * 2.0;
        g2d.setColor(this.hundredsPointerColor);
        g2d.rotate(hundRotation);
        double hundHeight = (diameter / 2.0 - (double)this.margin - (double)textMargin) / 1.3;
        p = new Polygon(new int[]{-2, 2, 0}, new int[]{0, 0, -((int)hundHeight)}, 3);
        g2d.fill(p);
        g2d.fill(this.centerHund);
        g2d.rotate(-hundRotation);
        g2d.setColor(this.backColor);
        Ellipse2D.Double ellisC = new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0);
        g2d.fill(ellisC);
        g2d.setColor(this.textColor);
        String meters = "" + this.curValue;
        Rectangle2D sBounds = g2d.getFontMetrics().getStringBounds(meters, g2d);
        g.drawString(meters, (int)(-sBounds.getWidth()) / 2, 20);
        if (this.getLabel() != null && !"".equalsIgnoreCase(this.getLabel())) {
            Rectangle2D lBounds = g2d.getFontMetrics().getStringBounds(this.getLabel(), g2d);
            g.drawString(this.getLabel(), (int)(-lBounds.getWidth()) / 2, -12);
        }
        g2d.setTransform(pre);
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color backColor) {
        this.backColor = backColor;
    }

    public Color getHundredsPointerColor() {
        return this.hundredsPointerColor;
    }

    public void setHundredsPointerColor(Color hundredsPointerColor) {
        this.hundredsPointerColor = hundredsPointerColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getThousandsPointerColor() {
        return this.thousandsPointerColor;
    }

    public void setThousandsPointerColor(Color thousandsPointerColor) {
        this.thousandsPointerColor = thousandsPointerColor;
    }

    public int getCurValue() {
        return this.curValue;
    }

    public void setCurValue(int curValue) {
        int oldValue = this.curValue;
        if (curValue != oldValue) {
            this.curValue = curValue;
            this.repaint();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.repaint();
    }

    public static void main(String[] args) {
        final AltitudePanel ap = new AltitudePanel();
        ap.setLabel("m");
        GuiUtils.testFrame(ap, "Testing the altitude panel");
        TimerTask tt = new TimerTask(){
            int val = 0;

            @Override
            public void run() {
                this.val += 20;
                ap.setCurValue(this.val);
            }
        };
        Timer t = new Timer("AltitudePanel");
        t.scheduleAtFixedRate(tt, 0L, 10L);
    }
}

