/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import pt.lsts.neptus.messages.Bitmask;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class BitmaskPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private long oldValue = 0L;
    private boolean cancelled = false;
    private JDialog dialog = null;
    private LinkedHashMap<Long, JCheckBox> checks = new LinkedHashMap();

    private BitmaskPanel(Bitmask bitmask, JDialog dialog) {
        this.oldValue = bitmask.getCurrentValue();
        this.dialog = dialog;
        this.setLayout(new BorderLayout());
        JPanel mainContent = new JPanel(new FlowLayout(1, 0, 0));
        for (long l : bitmask.getPossibleValues().keySet()) {
            String bitName = bitmask.getPossibleValues().get(l);
            JCheckBox check = new JCheckBox(bitName);
            check.setPreferredSize(new Dimension(130, 30));
            check.setSelected(bitmask.isSet(bitName));
            this.checks.put(l, check);
            mainContent.add(check);
        }
        this.add((Component)mainContent, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BitmaskPanel.this.dialog.setVisible(false);
                BitmaskPanel.this.dialog.dispose();
            }
        });
        okBtn.setPreferredSize(new Dimension(80, 25));
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BitmaskPanel.this.cancelled = true;
                BitmaskPanel.this.dialog.setVisible(false);
                BitmaskPanel.this.dialog.dispose();
            }
        });
        cancelBtn.setPreferredSize(new Dimension(80, 25));
        controls.add(okBtn);
        controls.add(cancelBtn);
        this.add((Component)controls, "South");
    }

    public long getValue() {
        if (this.cancelled) {
            return this.oldValue;
        }
        long value = 0L;
        for (long l : this.checks.keySet()) {
            if (!this.checks.get(l).isSelected()) continue;
            value |= l;
        }
        return value;
    }

    public static Bitmask showBitmaskDialog(Bitmask bitmask) {
        JDialog dialog = new JDialog(ConfigFetch.getSuperParentAsFrame(), true);
        dialog.setAlwaysOnTop(true);
        BitmaskPanel bpanel = new BitmaskPanel(bitmask, dialog);
        dialog.setContentPane(bpanel);
        dialog.setTitle("Bitmask Editor");
        dialog.setSize(540, (bitmask.getPossibleValues().size() / 4 + 2) * 30 + 50);
        GuiUtils.centerOnScreen(dialog);
        dialog.setVisible(true);
        bitmask.setCurrentValue(bpanel.getValue());
        return bitmask;
    }
}

