/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyEventDispatcher;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.gui.InfiniteProgressPanel;
import pt.lsts.neptus.util.GuiUtils;

public class BlockingGlassPane
extends JPanel {
    private int blockCount = 0;
    private BlockMouse blockMouse = new BlockMouse();
    private BlockKeys blockKeys = new BlockKeys();
    private InfiniteProgressPanel ipp;

    public BlockingGlassPane() {
        this(200);
    }

    public BlockingGlassPane(int size) {
        this(size, false);
    }

    public BlockingGlassPane(int size, boolean isOpaque) {
        this.setVisible(false);
        this.setOpaque(isOpaque);
        this.ipp = InfiniteProgressPanel.createInfinitePanelBeans("");
        this.ipp.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add(this.ipp);
        this.addMouseListener(this.blockMouse);
    }

    public String getText() {
        return this.ipp.getText();
    }

    public void setText(String message) {
        this.ipp.setText(message);
    }

    @Override
    public void setToolTipText(String text) {
        this.ipp.setToolTipText(text);
    }

    public void block(boolean block) {
        if (block) {
            if (this.blockCount == 0) {
                this.ipp.start();
                this.setVisible(true);
                this.setCursor(Cursor.getPredefinedCursor(3));
                FocusManager.getCurrentManager().addKeyEventDispatcher(this.blockKeys);
            }
            ++this.blockCount;
        } else {
            if (this.blockCount != 0) {
                --this.blockCount;
            }
            if (this.blockCount == 0) {
                FocusManager.getCurrentManager().removeKeyEventDispatcher(this.blockKeys);
                this.setCursor(Cursor.getDefaultCursor());
                this.setVisible(false);
                this.ipp.stop();
            }
        }
    }

    public boolean isBlocked() {
        return this.blockCount > 0;
    }

    public static void main(String[] args) {
        BlockingGlassPane bgp = new BlockingGlassPane();
        GuiUtils.testFrame(new JButton("Test"), "Test", 790, 560).setGlassPane(bgp);
        bgp.block(true);
    }

    private class BlockMouse
    extends MouseAdapter {
        private BlockMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private class BlockKeys
    implements KeyEventDispatcher {
        private BlockKeys() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent ev) {
            Component source = ev.getComponent();
            if (source != null && SwingUtilities.isDescendingFrom(source, BlockingGlassPane.this.getParent())) {
                Toolkit.getDefaultToolkit().beep();
                ev.consume();
                return true;
            }
            return false;
        }
    }
}

