/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatter;
import pt.lsts.neptus.gui.ClockCounter;
import pt.lsts.neptus.gui.MiniButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public class ChronometerPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static Color COLOR_OK = ClockCounter.COLOR_BACK;
    public static Color COLOR_NOK = new Color(255, 50, 0);
    private final String ACTION_START_STOP = "StartStop";
    private final String ACTION_PAUSE_RESUME = "PauseResume";
    private final String ACTION_COUNTDOWN = "Countdown";
    private final String ACTION_RESET = "Reset";
    private final String ACTION_ALARM = "Alarm";
    private final ImageIcon ICON_START = ImageUtils.getScaledIcon("images/chronometer/play.png", 16, 16);
    private final ImageIcon ICON_STOP = ImageUtils.getScaledIcon("images/chronometer/stop.png", 16, 16);
    private final ImageIcon ICON_PAUSE = ImageUtils.getScaledIcon("images/chronometer/pause.png", 16, 16);
    private final ImageIcon ICON_RESUME = ImageUtils.getScaledIcon("images/chronometer/fwd.png", 16, 16);
    private final ImageIcon ICON_DOWN = ImageUtils.getScaledIcon("images/chronometer/down.png", 16, 16);
    private final ImageIcon ICON_UP = ImageUtils.getScaledIcon("images/chronometer/up.png", 16, 16);
    private final ImageIcon ICON_RESET = ImageUtils.getScaledIcon("images/chronometer/restart.png", 16, 16);
    private final ImageIcon ICON_ALARM_ON = ImageUtils.getScaledIcon("images/chronometer/alarm.png", 16, 16);
    private final ImageIcon ICON_ALARM_OFF = ImageUtils.getScaledIcon("images/chronometer/alarm_disabled.png", 16, 16);
    private long msStart = 0L;
    private long msEnd = -1L;
    private long msStop = 0L;
    private long msAcum = 0L;
    private long msTime = 0L;
    private long maxSecs = -1L;
    protected CronState cState = CronState.STOPED;
    private Thread guiUpdateThread = null;
    private ClockCounter display = null;
    private MiniButton startStopToggleButton = null;
    private MiniButton pauseResumeToggleButton = null;
    private MiniButton alarmValueButton = null;
    private MiniButton countdownToggleButton = null;
    private MiniButton resetButton = null;

    public ChronometerPanel() {
        this.removeAll();
        this.initialize();
    }

    private void initialize() {
        this.setBackground(COLOR_OK);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.getDisplay())).addGroup(layout.createSequentialGroup().addComponent(this.getStartStopToggleButton()).addComponent(this.getPauseResumeToggleButton()).addComponent(this.getAlarmValueButton()).addComponent(this.getCountdownToggleButton())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.getDisplay()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getStartStopToggleButton()).addComponent(this.getPauseResumeToggleButton()).addComponent(this.getAlarmValueButton()).addComponent(this.getCountdownToggleButton()))));
        layout.linkSize(0, this.getStartStopToggleButton(), this.getPauseResumeToggleButton(), this.getAlarmValueButton(), this.getCountdownToggleButton());
        layout.linkSize(1, this.getStartStopToggleButton(), this.getPauseResumeToggleButton(), this.getAlarmValueButton(), this.getCountdownToggleButton());
    }

    public void hideButtons() {
        this.getStartStopToggleButton().setVisible(false);
        this.getPauseResumeToggleButton().setVisible(false);
        this.getAlarmValueButton().setVisible(false);
        this.getCountdownToggleButton().setVisible(false);
        this.getResetButton().setVisible(false);
    }

    public void unHideButtons() {
        this.getStartStopToggleButton().setVisible(true);
        this.getPauseResumeToggleButton().setVisible(true);
        this.getAlarmValueButton().setVisible(true);
        this.getCountdownToggleButton().setVisible(true);
    }

    protected ClockCounter getDisplay() {
        if (this.display == null) {
            this.display = new ClockCounter();
            final JPopupMenu popup = new JPopupMenu();
            popup.add(new JMenuItem(new AbstractAction(I18n.text("Copy time")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClipboardOwner owner = new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    };
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ChronometerPanel.this.getFormattedTime()), owner);
                }
            }));
            this.display.add(popup);
            this.display.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    popup.show(ChronometerPanel.this.display, e.getX(), e.getY());
                    super.mouseClicked(e);
                }
            });
        }
        return this.display;
    }

    protected MiniButton getStartStopToggleButton() {
        if (this.startStopToggleButton == null) {
            this.startStopToggleButton = new MiniButton();
            this.startStopToggleButton.setToggle(true);
            this.startStopToggleButton.setIcon(this.ICON_START);
            this.startStopToggleButton.setActionCommand("StartStop");
            this.startStopToggleButton.addActionListener(this);
            this.startStopToggleButton.setToolTipText(I18n.text("Start/Stop"));
        }
        return this.startStopToggleButton;
    }

    protected MiniButton getPauseResumeToggleButton() {
        if (this.pauseResumeToggleButton == null) {
            this.pauseResumeToggleButton = new MiniButton();
            this.pauseResumeToggleButton.setToggle(true);
            this.pauseResumeToggleButton.setIcon(this.ICON_PAUSE);
            this.pauseResumeToggleButton.setActionCommand("PauseResume");
            this.pauseResumeToggleButton.addActionListener(this);
            this.pauseResumeToggleButton.setToolTipText(I18n.text("Pause/Resume"));
        }
        return this.pauseResumeToggleButton;
    }

    protected MiniButton getCountdownToggleButton() {
        if (this.countdownToggleButton == null) {
            this.countdownToggleButton = new MiniButton();
            this.countdownToggleButton.setToggle(true);
            this.countdownToggleButton.setIcon(this.ICON_UP);
            this.countdownToggleButton.setActionCommand("Countdown");
            this.countdownToggleButton.addActionListener(this);
            this.countdownToggleButton.setToolTipText(I18n.text("Count Up/Down"));
        }
        return this.countdownToggleButton;
    }

    protected MiniButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new MiniButton();
            this.resetButton.setIcon(this.ICON_RESET);
            this.resetButton.setActionCommand("Reset");
            this.resetButton.addActionListener(this);
            this.resetButton.setToolTipText(I18n.text("Reset"));
            this.resetButton.setVisible(false);
        }
        return this.resetButton;
    }

    protected MiniButton getAlarmValueButton() {
        if (this.alarmValueButton == null) {
            this.alarmValueButton = new MiniButton();
            this.alarmValueButton.setIcon(this.ICON_ALARM_OFF);
            this.alarmValueButton.setActionCommand("Alarm");
            this.alarmValueButton.addActionListener(this);
            this.alarmValueButton.setToolTipText(I18n.text("Alarm Value"));
        }
        return this.alarmValueButton;
    }

    public void start() {
        if (!this.getStartStopToggleButton().getState()) {
            this.getStartStopToggleButton().doClick();
        }
    }

    public void stop() {
        if (this.getStartStopToggleButton().getState()) {
            this.getStartStopToggleButton().doClick();
        }
    }

    public void pause() {
        if (!this.getPauseResumeToggleButton().getState()) {
            this.getPauseResumeToggleButton().doClick();
        }
    }

    public void resume() {
        if (this.getPauseResumeToggleButton().getState()) {
            this.getPauseResumeToggleButton().doClick();
        }
    }

    public void countDown() {
        if (!this.getCountdownToggleButton().getState()) {
            this.getCountdownToggleButton().doClick();
        }
    }

    public void countUp() {
        if (this.getCountdownToggleButton().getState()) {
            this.getCountdownToggleButton().doClick();
        }
    }

    public long getMilliSecTime() {
        if (this.cState == CronState.STARTED) {
            this.msTime = System.currentTimeMillis() - this.msStart + this.msAcum;
        } else if (this.cState == CronState.PAUSED) {
            this.msTime = this.msStop - this.msStart + this.msAcum;
        } else if (this.cState == CronState.STOPED) {
            this.msTime = this.msEnd - this.msStart + this.msAcum;
        }
        return this.msTime;
    }

    public long getSecTime() {
        return this.getMilliSecTime() / 1000L;
    }

    public long getMaxSecs() {
        return this.maxSecs;
    }

    public void setMaxSecs(long maxSecs) {
        this.maxSecs = maxSecs;
        if (maxSecs <= 0L) {
            this.alarmValueButton.setIcon(this.ICON_ALARM_OFF);
        } else {
            this.alarmValueButton.setIcon(this.ICON_ALARM_ON);
        }
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        String aCommand = a.getActionCommand();
        if (aCommand.equalsIgnoreCase("StartStop")) {
            boolean state = this.getStartStopToggleButton().getState();
            if (state) {
                this.updateState(CronEvent.START);
                this.getStartStopToggleButton().setIcon(this.ICON_STOP);
                if (this.getPauseResumeToggleButton().getState()) {
                    this.getPauseResumeToggleButton().setState(false);
                    this.getPauseResumeToggleButton().setIcon(this.ICON_PAUSE);
                }
            } else {
                this.updateState(CronEvent.STOP);
                this.getStartStopToggleButton().setIcon(this.ICON_START);
                if (this.getPauseResumeToggleButton().getState()) {
                    this.getPauseResumeToggleButton().setState(false);
                    this.getPauseResumeToggleButton().setIcon(this.ICON_PAUSE);
                }
            }
        } else if (aCommand.equalsIgnoreCase("PauseResume")) {
            boolean state = this.getPauseResumeToggleButton().getState();
            if (state) {
                this.updateState(CronEvent.PAUSE);
                this.getPauseResumeToggleButton().setIcon(this.ICON_RESUME);
            } else {
                this.updateState(CronEvent.RESUME);
                this.getPauseResumeToggleButton().setIcon(this.ICON_PAUSE);
            }
        } else if (aCommand.equalsIgnoreCase("Countdown")) {
            boolean state = this.getCountdownToggleButton().getState();
            if (state) {
                this.getCountdownToggleButton().setIcon(this.ICON_DOWN);
                if (this.msEnd > 0L) {
                    this.updateDisplay();
                }
            } else {
                this.getCountdownToggleButton().setIcon(this.ICON_UP);
                if (this.msEnd > 0L) {
                    this.updateDisplay();
                }
            }
        } else if (aCommand.equalsIgnoreCase("Reset")) {
            if (this.cState == CronState.STOPED) {
                this.setMaxSecs(0L);
            }
        } else if (aCommand.equalsIgnoreCase("Alarm")) {
            final JFormattedTextField value = new JFormattedTextField(new HMSFormatter());
            value.setColumns(9);
            value.setValue(this.getMaxSecs() <= 0L ? 0L : this.getMaxSecs());
            value.setSelectionStart(0);
            value.setSelectionEnd(value.getText().length());
            final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(this), I18n.text("Enter the max. time"));
            JPanel jp = new JPanel();
            jp.setLayout(new FlowLayout());
            jp.add(value);
            final JButton okButton = new JButton(I18n.text("Ok"));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChronometerPanel.this.setMaxSecs((Long)value.getValue());
                    dialog.setVisible(false);
                }
            });
            value.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    super.keyReleased(e);
                    if (e.getKeyCode() == 10) {
                        okButton.doClick(50);
                    }
                }
            });
            jp.add(okButton);
            dialog.add(jp);
            dialog.setSize(200, 100);
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
            dialog.setVisible(true);
        }
    }

    protected void updateState(CronEvent event) {
        if (this.cState == CronState.STOPED) {
            if (event == CronEvent.START) {
                this.msTime = 0L;
                this.msStart = System.currentTimeMillis();
                this.msEnd = -1L;
                this.msAcum = 0L;
                this.msStop = -1L;
                this.cState = CronState.STARTED;
                this.startDisplayUpdate();
            }
        } else if (this.cState == CronState.STARTED) {
            if (event == CronEvent.PAUSE) {
                this.msStop = System.currentTimeMillis();
                this.cState = CronState.PAUSED;
            } else if (event == CronEvent.STOP) {
                this.msEnd = System.currentTimeMillis();
                this.cState = CronState.STOPED;
                this.stopDisplayUpdate();
                this.updateDisplay();
            }
        } else if (this.cState == CronState.PAUSED) {
            if (event == CronEvent.RESUME) {
                this.msAcum += this.msStop - this.msStart;
                this.msStart = System.currentTimeMillis();
                this.cState = CronState.STARTED;
            } else if (event == CronEvent.STOP) {
                this.msEnd = this.msStop;
                this.cState = CronState.STOPED;
                this.stopDisplayUpdate();
                this.updateDisplay();
            }
        }
    }

    protected void startDisplayUpdate() {
        if (this.guiUpdateThread == null) {
            this.guiUpdateThread = new Thread(this.getClass().getSimpleName() + ":" + Integer.toHexString(this.hashCode())){

                @Override
                public void run() {
                    try {
                        while (true) {
                            ChronometerPanel.this.updateDisplay();
                            Thread.sleep(250L);
                            Thread.yield();
                        }
                    }
                    catch (Exception exception) {
                        ChronometerPanel.this.guiUpdateThread = null;
                        return;
                    }
                }
            };
            this.guiUpdateThread.setDaemon(true);
            this.guiUpdateThread.start();
        }
    }

    protected void stopDisplayUpdate() {
        if (this.guiUpdateThread != null) {
            this.guiUpdateThread.interrupt();
        }
    }

    public void updateDisplay() {
        long t = this.getMilliSecTime() / 1000L;
        if (this.getMaxSecs() <= 0L && this.getCountdownToggleButton().getState()) {
            this.getCountdownToggleButton().doClick();
            this.getDisplay().setSecs(t);
        } else if (this.getMaxSecs() > 0L && this.getCountdownToggleButton().getState()) {
            long tm = this.getMaxSecs() - t;
            this.getDisplay().setSecs(tm < 0L ? 0L : tm);
        } else {
            this.getDisplay().setSecs(t);
        }
        if (this.cState == CronState.STARTED) {
            this.getDisplay().setState(ClockCounter.ClockState.START);
        } else if (this.cState == CronState.STOPED) {
            this.getDisplay().setState(ClockCounter.ClockState.STOP);
        } else if (this.cState == CronState.PAUSED) {
            this.getDisplay().setState(ClockCounter.ClockState.PAUSE);
        } else {
            this.getDisplay().setState(ClockCounter.ClockState.NONE);
        }
        if (t >= this.getMaxSecs() && this.getMaxSecs() > 0L) {
            this.getDisplay().setBackground(COLOR_NOK);
        } else {
            this.getDisplay().setBackground(COLOR_OK);
        }
    }

    public String getFormattedTime() {
        double millisVal = this.getMilliSecTime();
        long hr = (long)(millisVal / 1000.0 / 60.0 / 60.0 % 24.0);
        long mi = (long)(millisVal / 1000.0 / 60.0 % 60.0);
        double sec = millisVal / 1000.0 % 60.0;
        String hrS = Long.toString(hr);
        String miS = Long.toString(mi);
        String secS = Double.toString(MathMiscUtils.round(sec, 3));
        if (hrS.length() == 1) {
            hrS = "0" + hrS;
        }
        if (miS.length() == 1) {
            miS = "0" + miS;
        }
        if (Long.toString((long)sec).length() == 1) {
            secS = "0" + secS;
        }
        String time = "" + hrS + ClockCounter.HOURS_SEPARATOR + miS + ClockCounter.MINUTES_SEPARATOR + secS + ClockCounter.SECONDS_SEPARATOR;
        return time;
    }

    public static void main(String[] args) {
        ChronometerPanel chronometerPanel = new ChronometerPanel();
        GuiUtils.testFrame(chronometerPanel, ChronometerPanel.class.getSimpleName(), 400, 204);
    }

    public class HMSFormatter
    extends DefaultFormatter {
        private static final long serialVersionUID = 1L;
        Pattern regex = Pattern.compile("^(((((\\d?\\d" + ClockCounter.HOURS_SEPARATOR + ")?\\d)?\\d" + ClockCounter.MINUTES_SEPARATOR + ")?)?\\d)?\\d" + ClockCounter.SECONDS_SEPARATOR + "?$");
        Matcher matcher;

        public HMSFormatter() {
            this.setValueClass(Long.class);
            this.setOverwriteMode(false);
            this.matcher = this.regex.matcher("");
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null) {
                return null;
            }
            this.matcher.reset(string);
            if (!this.matcher.matches()) {
                throw new ParseException("does not match regex", 0);
            }
            String[] sv = string.split("[" + ClockCounter.HOURS_SEPARATOR + ClockCounter.MINUTES_SEPARATOR + ClockCounter.SECONDS_SEPARATOR + "]");
            Long[] lv = new Long[]{0L, 0L, 0L};
            for (int i = 0; i < sv.length; ++i) {
                int k = sv.length - i - 1;
                lv[i] = Long.parseLong(sv[k]);
            }
            long ret = (long)((double)lv[0].longValue() + (double)lv[1].longValue() * 60.0 + (double)lv[2].longValue() * 60.0 * 60.0);
            return ret;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            long secVal;
            if (value == null) {
                return "0";
            }
            try {
                secVal = (Long)value;
            }
            catch (Exception e) {
                secVal = 0L;
            }
            long hr = (long)((double)secVal / 60.0 / 60.0 % 24.0);
            long mi = (long)((double)secVal / 60.0 % 60.0);
            long sec = (long)((double)secVal % 60.0);
            String hrS = Long.toString(hr);
            String miS = Long.toString(mi);
            String secS = Long.toString(sec);
            if (hrS.length() == 1) {
                hrS = "0" + hrS;
            }
            if (miS.length() == 1) {
                miS = "0" + miS;
            }
            if (secS.length() == 1) {
                secS = "0" + secS;
            }
            String time = "" + hrS + ClockCounter.HOURS_SEPARATOR + miS + ClockCounter.MINUTES_SEPARATOR + secS + ClockCounter.SECONDS_SEPARATOR;
            return time;
        }
    }

    public static enum CronEvent {
        NONE,
        STOP,
        START,
        PAUSE,
        RESUME;

    }

    public static enum CronState {
        STOPED,
        STARTED,
        PAUSED;

    }
}

