/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;

public class ClockCounter
extends JPanel {
    public static final Color COLOR_BACK = new Color(190, 220, 240);
    public static final Color COLOR_FORE = new Color(30, 30, 30);
    public static final String HOURS_SEPARATOR = I18n.textc("h", "Chronometer hour separator");
    public static final String MINUTES_SEPARATOR = I18n.textc("m", "Chronometer minutes separator");
    public static final String SECONDS_SEPARATOR = I18n.textc("s", "Chronometer seconds separator");
    protected static final Polygon SHAPE_PLAY = new Polygon(new int[]{-4, -4, -1}, new int[]{1, 3, 2}, 3);
    protected static final Polygon SHAPE_STOP = new Polygon(new int[]{-4, -4, -1, -1}, new int[]{1, 3, 3, 1}, 4);
    protected static final Polygon SHAPE_PAUSE1 = new Polygon(new int[]{-4, -4, -3, -3}, new int[]{1, 3, 3, 1}, 4);
    protected static final Polygon SHAPE_PAUSE2 = new Polygon(new int[]{-2, -2, -1, -1}, new int[]{1, 3, 3, 1}, 4);
    private long secs = 0L;
    private ClockState state = ClockState.NONE;

    public ClockCounter() {
        this.initialize();
    }

    private void initialize() {
        this.setBackground(COLOR_BACK);
        this.setForeground(COLOR_FORE);
    }

    public long getSecs() {
        return this.secs;
    }

    public void setSecs(long secs) {
        this.secs = secs;
        this.repaint();
    }

    public ClockState getState() {
        return this.state;
    }

    public void setState(ClockState state) {
        this.state = state;
    }

    @Override
    public void paint(Graphics g) {
        double sh0;
        super.paint(g);
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        LinearGradientPaint pt = new LinearGradientPaint(0.0f, 0.0f, this.getWidth() / 2, this.getHeight(), new float[]{0.0f, 1.0f}, new Color[]{this.getBackground().brighter(), this.getBackground().darker()});
        g2d.setPaint(pt);
        RoundRectangle2D.Double rrect = new RoundRectangle2D.Double(2.0, 2.0, this.getWidth() - 4, this.getHeight() - 4, 10.0, 10.0);
        g2d.fill(rrect);
        g2d.setFont(new Font("Arial", 1, 10));
        String tt = "00" + HOURS_SEPARATOR + "00" + MINUTES_SEPARATOR + "00" + SECONDS_SEPARATOR;
        Rectangle2D sB1 = g2d.getFontMetrics().getStringBounds(tt, g2d);
        long hr = (long)((double)this.getSecs() / 60.0 / 60.0);
        long mi = (long)((double)this.getSecs() / 60.0 % 60.0);
        long sec = (long)((double)this.getSecs() % 60.0);
        String hrS = Long.toString(hr);
        String miS = Long.toString(mi);
        String secS = Long.toString(sec);
        if (hrS.length() == 1) {
            hrS = "0" + hrS;
        }
        if (miS.length() == 1) {
            miS = "0" + miS;
        }
        if (secS.length() == 1) {
            secS = "0" + secS;
        }
        String time = " " + hrS + HOURS_SEPARATOR + miS + MINUTES_SEPARATOR + secS + SECONDS_SEPARATOR;
        Rectangle2D sB2 = g2d.getFontMetrics().getStringBounds(time, g2d);
        double sw0 = (double)w / sB1.getWidth();
        double scale = sw0 < (sh0 = (double)h / sB1.getHeight()) ? sw0 : sh0;
        w = (int)((double)(w * 1) / scale);
        h = (int)((double)(h * 1) / scale);
        g2d.scale(scale, scale);
        g2d.translate(w / 2, h / 2);
        g2d.setColor(COLOR_FORE);
        g.drawString(time, (int)(-sB2.getWidth() / 2.0), (int)(sB2.getHeight() / 2.0));
        g2d.translate(w / 2, -h / 2);
        if (this.getState() == ClockState.START) {
            g2d.fill(SHAPE_PLAY);
        } else if (this.getState() == ClockState.STOP) {
            g2d.fill(SHAPE_STOP);
        } else if (this.getState() == ClockState.PAUSE) {
            g2d.fill(SHAPE_PAUSE1);
            g2d.fill(SHAPE_PAUSE2);
        }
    }

    public static void main(String[] args) {
        final ClockCounter cp = new ClockCounter();
        GuiUtils.testFrame(cp, "Testing the clock panel", 300, 100);
        TimerTask tt = new TimerTask(){
            int val = 0;

            @Override
            public void run() {
                ++this.val;
                if (this.val % 60 == 0) {
                    cp.setBackground(Color.RED);
                } else {
                    cp.setBackground(COLOR_BACK);
                }
                cp.setSecs(this.val);
            }
        };
        Timer t = new Timer("Clock Counter");
        t.scheduleAtFixedRate(tt, 0L, 1000L);
    }

    public static enum ClockState {
        NONE,
        STOP,
        START,
        PAUSE;

    }
}

