/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ConsoleFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;

    public static File showOpenDialog(File basedir) {
        return ConsoleFileChooser.showOpenDialog(null, I18n.text("Open Console"), basedir);
    }

    public static File showOpenDialog(Component parent, File basedir) {
        return ConsoleFileChooser.showOpenDialog(parent, I18n.text("Open Console"), basedir);
    }

    public static File showOpenDialog() {
        return ConsoleFileChooser.showOpenDialog(null, I18n.text("Open Console"), null);
    }

    public static File showOpenConsoleDialog(Component parent) {
        return ConsoleFileChooser.showOpenDialog(parent, I18n.text("Open Console"), null);
    }

    public static File showSaveConsoleDialog(Component parent) {
        return ConsoleFileChooser.showOpenDialog(parent, I18n.text("Save Console"), null);
    }

    public static File showSaveDialog(File basedir) {
        return ConsoleFileChooser.showOpenDialog(null, I18n.text("Save Console"), basedir);
    }

    public static File showSaveDialog(Component parent, File basedir) {
        return ConsoleFileChooser.showOpenDialog(parent, I18n.text("Save Console"), basedir);
    }

    private static File showOpenDialog(Component parent, String title, File basedir) {
        File fx;
        JFileChooser jfc = new JFileChooser();
        if (basedir != null && basedir.exists()) {
            fx = basedir;
        } else {
            fx = new File(ConfigFetch.getConfigFile());
            if (!(fx = new File(fx.getParentFile(), "conf/consoles")).exists() && !(fx = new File(ConfigFetch.resolvePath("."))).exists()) {
                fx = new File(".");
            }
        }
        jfc.setCurrentDirectory(fx);
        jfc.setFileView(new NeptusFileView());
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileUtil.getFileExtension(f).toLowerCase();
                if (extension != null) {
                    return extension.equals("xml") || extension.equals("ncn") || extension.equals("ncon");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return I18n.textf("Console files (%extensions)", "'ncon', 'xml'");
            }
        });
        int result = jfc.showDialog(parent, title);
        if (result == 1) {
            return null;
        }
        return jfc.getSelectedFile();
    }

    public static File showOpenConsoleDialog() {
        return ConsoleFileChooser.showOpenConsoleDialog(new JFrame());
    }

    public static File showSaveConsoleDialog() {
        return ConsoleFileChooser.showOpenConsoleDialog(new JFrame());
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        File f = ConsoleFileChooser.showOpenConsoleDialog();
        NeptusLog.pub().info((Object)("<###> " + f));
    }
}

