/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

public class CoordinateSystemPanel
extends ParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 8236508411812031285L;
    private static final String HELP_IMAGE = "/images/rpy.png";
    private JPanel changeHomePanel = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel = null;
    private JButton changeCenter = null;
    private JLabel jLabel1 = null;
    private JTextField yawField = null;
    private LocationType centerLocation = new LocationType();
    private CoordinateSystem originalCoordinateSystem = null;
    private JPanel controlsPanel = null;
    private JButton cancelBtn = null;
    private JButton okBtn = null;
    private boolean userCancel = false;
    private JDialog dialog = null;
    private JLabel jLabel4 = null;
    private boolean editable = true;
    private String rpyHelpImage;
    private JCheckBox applyToMisson = null;
    private CoordinateSystem oldValue = null;

    public CoordinateSystemPanel() {
        this.initialize();
    }

    public CoordinateSystemPanel(CoordinateSystem cs) {
        this.originalCoordinateSystem = cs;
        if (cs != null) {
            this.centerLocation.setLocation(cs);
        }
        this.initialize();
        if (cs != null) {
            this.getYawField().setText(String.valueOf(cs.getYaw()));
            this.oldValue = new CoordinateSystem();
            this.oldValue.setLocation(cs);
            this.oldValue.setYaw(cs.getYaw());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    private void initialize() {
        this.rpyHelpImage = this.getClass().getResource(HELP_IMAGE).toString();
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(376, 103);
        this.setLocation(2, 0);
        this.add((Component)this.getChangeHomePanel(), null);
        this.add((Component)this.getJPanel1(), null);
    }

    @Override
    public String getErrors() {
        try {
            Double.parseDouble(this.getYawField().getText());
        }
        catch (Exception e) {
            return I18n.text("The angle offset is invalid!");
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LocationType tmp;
        if ("changecenter".equals(e.getActionCommand()) && (tmp = LocationPanel.showLocationDialog(this, I18n.text("Change the reference point"), this.centerLocation, null, this.editable)) != null) {
            this.centerLocation = tmp;
        }
        if ("ok".equals(e.getActionCommand())) {
            if (this.getErrors() != null) {
                JOptionPane.showMessageDialog(this.dialog, this.getErrors(), I18n.text("Errors in the parameters"), 0);
            } else {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
        if ("cancel".equals(e.getActionCommand())) {
            this.userCancel = true;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private JPanel getChangeHomePanel() {
        if (this.changeHomePanel == null) {
            FlowLayout flowLayout3 = new FlowLayout();
            this.jLabel = new JLabel();
            this.changeHomePanel = new JPanel();
            this.changeHomePanel.setLayout(flowLayout3);
            this.jLabel.setText("Central Location:");
            flowLayout3.setAlignment(0);
            this.changeHomePanel.add((Component)this.jLabel, null);
            this.changeHomePanel.add((Component)this.getChangeCenter(), null);
            this.changeHomePanel.add((Component)this.getApplyToMisson(), null);
        }
        return this.changeHomePanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            TitledBorder titledBorder1 = BorderFactory.createTitledBorder(null, I18n.text("Axis attitude"), 0, 0, null, null);
            this.jLabel4 = new JLabel();
            this.jLabel1 = new JLabel();
            this.jPanel1 = new JPanel();
            this.jPanel1.setEnabled(true);
            this.jPanel1.setBorder(titledBorder1);
            this.jLabel1.setText(I18n.text("Rotation over the vertical axis:"));
            this.jLabel4.setText(" (" + I18n.text("degrees") + ")");
            titledBorder1.setTitle(I18n.text("Offset Angle North"));
            this.jPanel1.add((Component)this.jLabel1, null);
            this.jPanel1.add((Component)this.getYawField(), null);
            this.jPanel1.add((Component)this.jLabel4, null);
        }
        return this.jPanel1;
    }

    private JButton getChangeCenter() {
        if (this.changeCenter == null) {
            this.changeCenter = new JButton();
            this.changeCenter.setText(I18n.text("Change..."));
            this.changeCenter.setActionCommand("changecenter");
            this.changeCenter.addActionListener(this);
        }
        return this.changeCenter;
    }

    private JTextField getYawField() {
        if (this.yawField == null) {
            this.yawField = new JTextField("0");
            this.yawField.setColumns(7);
            this.yawField.setToolTipText("<html><img src=\"" + this.rpyHelpImage + "\"></html>");
            this.yawField.addFocusListener(new SelectAllFocusListener());
        }
        return this.yawField;
    }

    public void getDialog(String title, JComponent parent) {
        if (parent == null) {
            parent = this;
        }
        Window tmpP = parent != null ? SwingUtilities.getWindowAncestor(parent) : null;
        Window windowParent = tmpP != null ? tmpP : new JFrame();
        this.dialog = new JDialog(windowParent, title);
        this.dialog.getContentPane().add(this);
        this.dialog.setSize(this.getWidth() + 5, this.getHeight() + 80);
        this.dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.dialog.setAlwaysOnTop(false);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CoordinateSystemPanel.this.userCancel = true;
                CoordinateSystemPanel.this.dialog.setVisible(false);
                CoordinateSystemPanel.this.dialog.dispose();
            }
        });
        GuiUtils.centerOnScreen(this.dialog);
        this.add(this.getControlsPanel());
        this.dialog.setVisible(true);
    }

    public CoordinateSystem getCoordinateSystem() {
        if (this.userCancel) {
            return this.originalCoordinateSystem;
        }
        CoordinateSystem cs = new CoordinateSystem();
        cs.setLocation(this.centerLocation);
        cs.setRoll(0.0);
        cs.setPitch(0.0);
        cs.setYaw(Double.parseDouble(this.getYawField().getText()));
        if (cs.getDistanceInMeters(new LocationType(this.originalCoordinateSystem)) != 0.0 && this.getApplyToMisson().isSelected()) {
            MapGroup missonMaps = MapGroup.getMapGroupInstance(this.getMissionType());
            TreeMap<String, PlanType> plans = this.getMissionType().getIndividualPlansList();
            double[] offsets = cs.getOffsetFrom(this.originalCoordinateSystem);
            double offsetNorth = offsets[0];
            double offsetEast = offsets[1];
            double offsetDown = offsets[2];
            for (MapType map : missonMaps.maps.values()) {
                NeptusLog.pub().debug((Object)("Translating map " + map.getId() + "..."));
                for (AbstractElement mo : map.getObjects()) {
                    NeptusLog.pub().debug((Object)("\tTranslating the " + mo.getClass().getSimpleName() + " " + mo.getId() + "..."));
                    LocationType lt = mo.getCenterLocation();
                    lt.translatePosition(offsetNorth, offsetEast, offsetDown);
                    mo.setCenterLocation(lt);
                }
                map.warnChangeListeners(new MapChangeEvent(-1));
            }
            for (PlanType plan : plans.values()) {
                NeptusLog.pub().debug((Object)("Translating plan " + plan.getId() + "..."));
                for (Maneuver man : plan.getGraph().getAllManeuvers()) {
                    if (!(man instanceof LocatedManeuver)) continue;
                    NeptusLog.pub().debug((Object)("\tTranslating the " + man.getClass().getSimpleName() + " " + man.getId() + "..."));
                    LocatedManeuver transMan = (LocatedManeuver)((Object)man);
                    transMan.translate(offsetNorth, offsetEast, offsetDown);
                }
            }
        }
        return cs;
    }

    public static CoordinateSystem showCoordinateSystemDialog(String title, JComponent parent) {
        CoordinateSystemPanel csp = new CoordinateSystemPanel();
        csp.getDialog(title, parent);
        return csp.getCoordinateSystem();
    }

    public static CoordinateSystem showCoordinateSystemDialog(String title, CoordinateSystem cs, JComponent parent) {
        CoordinateSystemPanel csp = new CoordinateSystemPanel(cs);
        csp.getDialog(title, parent);
        return csp.getCoordinateSystem();
    }

    public static CoordinateSystem showHomeRefDialog(String title, HomeReference cs, JComponent parent) {
        CoordinateSystemPanel csp = new CoordinateSystemPanel(cs);
        csp.setMissionType(cs.getMission());
        csp.getDialog(title, parent);
        return csp.getCoordinateSystem();
    }

    public static CoordinateSystem showCoordinateSystemDialogNoEdit(String title, CoordinateSystem cs, JComponent parent) {
        CoordinateSystemPanel csp = new CoordinateSystemPanel(cs);
        csp.setEditable(false);
        csp.getDialog(title, parent);
        return csp.getCoordinateSystem();
    }

    private JPanel getControlsPanel() {
        if (this.controlsPanel == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            this.controlsPanel = new JPanel();
            this.controlsPanel.setLayout(flowLayout2);
            flowLayout2.setAlignment(2);
            this.controlsPanel.add((Component)this.getOkBtn(), null);
            this.controlsPanel.add((Component)this.getCancelBtn(), null);
        }
        return this.controlsPanel;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null) {
            this.cancelBtn = new JButton();
            this.cancelBtn.setText(I18n.text("Cancel"));
            this.cancelBtn.setActionCommand("cancel");
            this.cancelBtn.addActionListener(this);
        }
        return this.cancelBtn;
    }

    private JButton getOkBtn() {
        if (this.okBtn == null) {
            this.okBtn = new JButton();
            this.okBtn.setText(I18n.text("OK"));
            this.okBtn.setActionCommand("ok");
            this.okBtn.addActionListener(this);
        }
        return this.okBtn;
    }

    public void setChangeHomeVisible(boolean value) {
        this.getChangeHomePanel().setVisible(value);
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getYawField().setEditable(this.editable);
        this.getCancelBtn().setVisible(this.editable);
        this.getApplyToMisson().setEnabled(false);
    }

    private JCheckBox getApplyToMisson() {
        if (this.applyToMisson == null) {
            this.applyToMisson = new JCheckBox(I18n.text("Propagate"));
            this.applyToMisson.setSelected(false);
            this.applyToMisson.setToolTipText(I18n.text("Translate all mission accordingly to changes"));
        }
        return this.applyToMisson;
    }

    public static void main(String[] args) {
        CoordinateSystem cs = CoordinateSystemPanel.showCoordinateSystemDialog("Teste unit\u00e1rio", null);
        NeptusLog.pub().info((Object)("<###> " + cs));
    }
}

