/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class DesktopIcon
extends JLabel {
    private int growSize = 8;
    private ActionListener listener;
    private Point lastDragPoint = null;
    Icon iconN = null;
    Icon iconF = null;

    public DesktopIcon(Icon icon, String text, ActionListener listener) {
        super(text, icon, 0);
        this.iconN = icon;
        this.listener = listener;
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                if (DesktopIcon.this.lastDragPoint != null) {
                    int diffX = e.getXOnScreen() - ((DesktopIcon)DesktopIcon.this).lastDragPoint.x;
                    int diffY = e.getYOnScreen() - ((DesktopIcon)DesktopIcon.this).lastDragPoint.y;
                    Point loc = DesktopIcon.this.getLocation();
                    DesktopIcon.this.setLocation(loc.x + diffX, loc.y + diffY);
                    DesktopIcon.this.getParent().invalidate();
                }
                DesktopIcon.this.lastDragPoint = new Point(e.getXOnScreen(), e.getYOnScreen());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() >= 2) {
                    DesktopIcon.this.listener.actionPerformed(new ActionEvent(this, 0, DesktopIcon.this.getText()));
                } else if (e.getClickCount() == 1) {
                    try {
                        DesktopIcon.this.getComponentPopupMenu().setVisible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                DesktopIcon.this.lastDragPoint = new Point(e.getXOnScreen(), e.getYOnScreen());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                DesktopIcon.this.lastDragPoint = null;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DesktopIcon.this.iconF != null) {
                    DesktopIcon.this.setIcon(DesktopIcon.this.iconF);
                    DesktopIcon.this.setSize(DesktopIcon.this.getWidth() + DesktopIcon.this.growSize, DesktopIcon.this.getHeight() + DesktopIcon.this.growSize);
                }
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (DesktopIcon.this.iconF != null) {
                    DesktopIcon.this.setIcon(DesktopIcon.this.iconN);
                    DesktopIcon.this.setSize(DesktopIcon.this.getWidth() - DesktopIcon.this.growSize, DesktopIcon.this.getHeight() - DesktopIcon.this.growSize);
                }
                super.mouseExited(e);
            }
        });
        this.setBounds(0, 0, (int)this.getPreferredSize().getWidth(), (int)this.getPreferredSize().getHeight());
        if (this.iconN instanceof ImageIcon) {
            ImageIcon iic = (ImageIcon)this.iconN;
            Image img = iic.getImage();
            int height = img.getHeight(null);
            int width = img.getWidth(null);
            this.growSize = (int)((double)width * 0.25);
            Image imgS = img.getScaledInstance(width + this.growSize, height + this.growSize, 4);
            this.iconF = new ImageIcon(imgS);
        }
    }
}

