/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableModel;

public class DragAndDropTableUI
extends BasicTableUI {
    private boolean draggingRow = false;
    private int startDragPoint;
    private int dyOffset;

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new DragDropRowMouseInputHandler();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.draggingRow) {
            g.setColor(this.table.getParent().getBackground());
            Rectangle cellRect = this.table.getCellRect(this.table.getSelectedRow(), 0, false);
            g.copyArea(cellRect.x, cellRect.y, this.table.getWidth(), this.table.getRowHeight(), cellRect.x, this.dyOffset);
            if (this.dyOffset < 0) {
                g.fillRect(cellRect.x, cellRect.y + (this.table.getRowHeight() + this.dyOffset), this.table.getWidth(), this.dyOffset * -1);
            } else {
                g.fillRect(cellRect.x, cellRect.y, this.table.getWidth(), this.dyOffset);
            }
        }
    }

    class DragDropRowMouseInputHandler
    extends BasicTableUI.MouseInputHandler {
        DragDropRowMouseInputHandler() {
            super(DragAndDropTableUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            DragAndDropTableUI.this.startDragPoint = (int)e.getPoint().getY();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int fromRow = DragAndDropTableUI.this.table.getSelectedRow();
            if (fromRow >= 0) {
                DragAndDropTableUI.this.draggingRow = true;
                int rowHeight = DragAndDropTableUI.this.table.getRowHeight();
                int middleOfSelectedRow = rowHeight * fromRow + rowHeight / 2;
                int toRow = -1;
                int yMousePoint = (int)e.getPoint().getY();
                if (yMousePoint < middleOfSelectedRow - rowHeight) {
                    toRow = fromRow - 1;
                } else if (yMousePoint > middleOfSelectedRow + rowHeight) {
                    toRow = fromRow + 1;
                }
                if (toRow >= 0 && toRow < DragAndDropTableUI.this.table.getRowCount()) {
                    TableModel model = DragAndDropTableUI.this.table.getModel();
                    for (int i = 0; i < model.getColumnCount(); ++i) {
                        Object fromValue = model.getValueAt(fromRow, i);
                        Object toValue = model.getValueAt(toRow, i);
                        model.setValueAt(toValue, fromRow, i);
                        model.setValueAt(fromValue, toRow, i);
                    }
                    DragAndDropTableUI.this.table.setRowSelectionInterval(toRow, toRow);
                    DragAndDropTableUI.this.startDragPoint = yMousePoint;
                }
                DragAndDropTableUI.this.dyOffset = (DragAndDropTableUI.this.startDragPoint - yMousePoint) * -1;
                DragAndDropTableUI.this.table.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            DragAndDropTableUI.this.draggingRow = false;
            DragAndDropTableUI.this.table.repaint();
        }
    }
}

