/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;

public class ErrorMessageBox
extends JDialog {
    private JPanel backPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel exception = null;
    private JLabel message = null;
    private JLabel cause = null;
    private JScrollPane jScrollPane = null;
    private JTextArea stackTrace = null;
    private JLabel jLabel11 = null;
    private JButton okButton = null;

    public ErrorMessageBox() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(530, 316));
        this.setTitle(I18n.text("Exception Thrown"));
        this.setContentPane(this.getBackPanel());
    }

    private JPanel getBackPanel() {
        if (this.backPanel == null) {
            this.jLabel11 = new JLabel();
            this.jLabel11.setText("<html><b>" + I18n.text("Stack Trace"));
            this.jLabel11.setBounds(new Rectangle(8, 80, 73, 16));
            this.cause = new JLabel();
            this.cause.setText("");
            this.cause.setBounds(new Rectangle(88, 56, 425, 17));
            this.exception = new JLabel();
            this.exception.setText("");
            this.exception.setBounds(new Rectangle(88, 8, 425, 17));
            this.message = new JLabel();
            this.message.setText("");
            this.message.setBounds(new Rectangle(88, 32, 425, 17));
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("<html><b>" + I18n.text("Message") + ":");
            this.jLabel1.setBounds(new Rectangle(8, 32, 73, 17));
            this.jLabel = new JLabel();
            this.jLabel.setText("<html><b>" + I18n.text("Exception") + ":");
            this.jLabel.setBounds(new Rectangle(8, 8, 73, 17));
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("<html><b>" + I18n.text("Cause") + ":");
            this.jLabel2.setBounds(new Rectangle(8, 56, 73, 17));
            this.backPanel = new JPanel();
            this.backPanel.setLayout(null);
            this.backPanel.add((Component)this.jLabel, null);
            this.backPanel.add((Component)this.jLabel1, null);
            this.backPanel.add((Component)this.jLabel2, null);
            this.backPanel.add((Component)this.exception, null);
            this.backPanel.add((Component)this.cause, null);
            this.backPanel.add((Component)this.message, null);
            this.backPanel.add((Component)this.getJScrollPane(), null);
            this.backPanel.add((Component)this.jLabel11, null);
            this.backPanel.add((Component)this.getOkButton(), null);
        }
        return this.backPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(new Rectangle(8, 96, 505, 144));
            this.jScrollPane.setViewportView(this.getStackTrace());
        }
        return this.jScrollPane;
    }

    private JTextArea getStackTrace() {
        if (this.stackTrace == null) {
            this.stackTrace = new JTextArea();
            this.stackTrace.setEditable(false);
            this.stackTrace.setBackground(Color.white);
        }
        return this.stackTrace;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(I18n.text("OK"));
            this.okButton.setBounds(new Rectangle(432, 248, 81, 25));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ErrorMessageBox.this.setVisible(false);
                    ErrorMessageBox.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    public static void showDialog(Component parent, Exception e) {
        ErrorMessageBox msgBox = new ErrorMessageBox();
        msgBox.setTitle(I18n.textf("%className thrown", e.getClass().getSimpleName()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(baos));
        msgBox.exception.setText(e.getClass().getSimpleName());
        if (e.getMessage() != null) {
            msgBox.message.setText(e.getMessage().toString());
        } else {
            msgBox.message.setText("(null)");
        }
        if (e.getCause() != null) {
            msgBox.cause.setText(e.getCause().toString());
        } else {
            msgBox.cause.setText("(null)");
        }
        msgBox.stackTrace.setText(baos.toString());
        msgBox.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        GuiUtils.centerOnScreen(msgBox);
        msgBox.setResizable(false);
        msgBox.setVisible(true);
    }

    public static void showDialog(Component parent, Exception e, String msg) {
        ErrorMessageBox msgBox = new ErrorMessageBox();
        msgBox.setTitle(I18n.textf("%className thrown", e.getClass().getSimpleName()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(baos));
        msgBox.exception.setText(e.getClass().getSimpleName());
        if (msg != null) {
            msgBox.message.setText(msg);
        } else {
            msgBox.message.setText("(null)");
        }
        if (e.getCause() != null) {
            msgBox.cause.setText(e.getCause().toString());
        } else {
            msgBox.cause.setText("(null)");
        }
        msgBox.stackTrace.setText(baos.toString());
        msgBox.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        GuiUtils.centerOnScreen(msgBox);
        msgBox.setResizable(false);
        msgBox.setVisible(true);
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        ErrorMessageBox.showDialog(null, new NullPointerException("sdfsdf"));
    }
}

