/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.ImageIcon;
import pt.lsts.neptus.gui.MissionBrowser;
import pt.lsts.neptus.util.ColorUtils;

class ExtendedIcon
extends ImageIcon {
    private static final long serialVersionUID = 5952273156817637800L;
    private static Color BLUE = ColorUtils.setTransparencyToColor(Color.BLUE, 90);
    private static Color GREEN = ColorUtils.setTransparencyToColor(Color.GREEN, 90);
    private static Color RED = ColorUtils.setTransparencyToColor(Color.RED, 90);
    protected MissionBrowser.State state = MissionBrowser.State.LOCAL;
    protected Image overImage = null;

    public ExtendedIcon(Image vImage) {
        super(vImage);
    }

    public ExtendedIcon(Image vImage, Image topImage) {
        super(vImage);
        this.overImage = topImage;
    }

    public MissionBrowser.State getState() {
        return this.state;
    }

    public void setState(MissionBrowser.State state) {
        this.state = state;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.getImage(), 0, 0, null);
        super.paintIcon(c, g, x, y);
        if (this.overImage != null) {
            g.drawImage(this.overImage, 0, 0, null);
        }
        if (this.state != MissionBrowser.State.LOCAL) {
            Graphics2D g2 = (Graphics2D)g.create(0, 0, this.getImage().getWidth(null), this.getImage().getHeight(null));
            Color color = this.state == MissionBrowser.State.SYNC ? GREEN : (this.state == MissionBrowser.State.REMOTE ? BLUE : RED);
            g2.setColor(color);
            g2.fill(g2.getClipBounds());
            g2.dispose();
        }
    }
}

