/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

public class GotoParameters
extends ParametersPanel
implements ActionListener {
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel = null;
    private JButton jButton = null;
    private JLabel jLabel1 = null;
    private JFormattedTextField velocity = null;
    private JFormattedTextField radiusTolerance = null;
    private JLabel jLabel2 = null;
    private JFormattedTextField velocityTolerance = null;
    private JComboBox<?> unitsCombo = null;
    private JLabel jLabel5 = null;
    private JLabel jLabel3 = null;
    private static NumberFormat nf = NumberFormat.getNumberInstance();
    private LocationType destination;

    public GotoParameters() {
        nf.setGroupingUsed(false);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(398, 152);
        this.add((Component)this.getJPanel(), null);
        this.add((Component)this.getJPanel1(), null);
    }

    @Override
    public String getErrors() {
        return null;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel3 = new JLabel();
            this.jLabel = new JLabel();
            this.jPanel = new JPanel();
            this.jLabel.setText("Destination:");
            this.jLabel3.setText(" Tolerance:");
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, "Destination", 0, 0, null, null));
            this.jPanel.add((Component)this.jLabel, null);
            this.jPanel.add((Component)this.getJButton(), null);
            this.jPanel.add((Component)this.jLabel3, null);
            this.jPanel.add((Component)this.getRadiusTolerance(), null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel2 = new JLabel();
            this.jLabel1 = new JLabel();
            this.jPanel1 = new JPanel();
            this.jLabel1.setText("Velocity:");
            this.jLabel2.setText("  Tolerance:");
            this.jLabel5.setText("  Units:");
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Velocity", 0, 0, null, null));
            this.jPanel1.add((Component)this.jLabel1, null);
            this.jPanel1.add((Component)this.getVelocity(), null);
            this.jPanel1.add((Component)this.jLabel2, null);
            this.jPanel1.add((Component)this.getVelocityTolerance(), null);
            this.jPanel1.add((Component)this.jLabel5, null);
            this.jPanel1.add(this.getUnitsCombo(), null);
        }
        return this.jPanel1;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(I18n.text("Change..."));
            this.jButton.setPreferredSize(new Dimension(90, 20));
            this.jButton.addActionListener(this);
        }
        return this.jButton;
    }

    private JFormattedTextField getVelocity() {
        if (this.velocity == null) {
            this.velocity = new JFormattedTextField(nf);
            this.velocity.setText("0.0");
            this.velocity.setColumns(4);
            this.velocity.setToolTipText(I18n.text("The desired velocity over the trajectory"));
            this.velocity.addFocusListener(new SelectAllFocusListener());
        }
        return this.velocity;
    }

    private JFormattedTextField getRadiusTolerance() {
        if (this.radiusTolerance == null) {
            this.radiusTolerance = new JFormattedTextField(nf);
            this.radiusTolerance.setText("0.0");
            this.radiusTolerance.setColumns(4);
            this.radiusTolerance.setToolTipText(I18n.text("The radius tolerance over the trajectory (in meters)"));
            this.radiusTolerance.addFocusListener(new SelectAllFocusListener());
        }
        return this.radiusTolerance;
    }

    private JFormattedTextField getVelocityTolerance() {
        if (this.velocityTolerance == null) {
            this.velocityTolerance = new JFormattedTextField(nf);
            this.velocityTolerance.setColumns(4);
            this.velocityTolerance.setText("0.0");
            this.velocityTolerance.setToolTipText(I18n.text("The maximum allowed drift in the velocity"));
            this.velocityTolerance.addFocusListener(new SelectAllFocusListener());
        }
        return this.velocityTolerance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LocationType loc = LocationPanel.showLocationDialog(I18n.text("Goto destination"), this.getDestination(), this.getMissionType());
        if (loc != null) {
            this.setDestination(loc);
        }
    }

    private JComboBox<?> getUnitsCombo() {
        if (this.unitsCombo == null) {
            String[] units = new String[]{I18n.text("RPM"), I18n.text("m/s")};
            this.unitsCombo = new JComboBox<String>(units);
            this.unitsCombo.setPreferredSize(new Dimension(70, 20));
        }
        return this.unitsCombo;
    }

    public String getUnits() {
        return (String)this.getUnitsCombo().getSelectedItem();
    }

    public double getVelocityValue() {
        return Double.parseDouble(this.getVelocity().getText());
    }

    public double getVelocityToleranceValue() {
        return Double.parseDouble(this.getVelocityTolerance().getText());
    }

    public double getRadiusToleranceValue() {
        return Double.parseDouble(this.getRadiusTolerance().getText());
    }

    public void setVelocityValue(double value) {
        this.getVelocity().setText(String.valueOf(value));
    }

    public void setVelocityToleranceValue(double value) {
        this.getVelocityTolerance().setText(String.valueOf(value));
    }

    public void setRadiusToleranceValue(double value) {
        this.getRadiusTolerance().setText(String.valueOf(value));
    }

    public void setUnits(String units) {
        this.getUnitsCombo().setSelectedItem(units);
    }

    public static void main(String[] args) {
        GuiUtils.testFrame(new GotoParameters(), "Teste Unit\u00e1rio");
    }

    public LocationType getDestination() {
        return this.destination;
    }

    public void setDestination(LocationType destination) {
        this.destination = destination;
    }
}

