/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.renderer3d.Renderer3D;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class Grid3D
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JFormattedTextField dimField = null;
    private JCheckBox checkNE = null;
    private JCheckBox checkUN = null;
    private JCheckBox checkUE = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JFormattedTextField cellSize = null;
    private JCheckBox showValues = null;
    private JButton colorBtn = null;
    private JButton color = null;
    private JButton cancelBtn = null;
    private JButton okBtn = null;
    private Renderer3D renderer = null;
    private NumberFormat df = GuiUtils.getNeptusDecimalFormat();
    private JLabel jLabel2 = null;
    private JFormattedTextField depthField = null;

    public Grid3D(Frame parent) {
        super(parent);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.setSize(471, 284);
    }

    public void setRenderer3D(Renderer3D r3d) {
        this.renderer = r3d;
        this.setValues();
    }

    private void setValues() {
        this.getCheckNE().setSelected(this.renderer.gNE);
        this.getCheckUE().setSelected(this.renderer.gUE);
        this.getCheckUN().setSelected(this.renderer.gUN);
        this.showValues.setSelected(this.renderer.gtext);
        this.dimField.setText(String.valueOf(this.renderer.gdimension));
        this.cellSize.setText(String.valueOf(this.renderer.gspacing));
        this.depthField.setText(String.valueOf(this.renderer.gcenter.z));
        this.color.setBackground(this.renderer.gcolor);
    }

    private void setRenderer() {
        this.renderer.gNE = this.checkNE.isSelected();
        this.renderer.gUE = this.checkUE.isSelected();
        this.renderer.gUN = this.checkUN.isSelected();
        this.renderer.gtext = this.showValues.isSelected();
        this.renderer.gdimension = Float.parseFloat(this.dimField.getText());
        this.renderer.gspacing = Float.parseFloat(this.cellSize.getText());
        this.renderer.gcenter.z = Float.parseFloat(this.depthField.getText());
        this.renderer.gcolor = this.color.getBackground();
        this.renderer.menuOKgrid();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel2 = new JLabel();
            this.jLabel1 = new JLabel();
            this.jLabel = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jLabel.setBounds(20, 95, 119, 25);
            this.jLabel.setText("Dimension (meters):");
            this.jLabel1.setBounds(20, 132, 110, 25);
            this.jLabel1.setText("Cell Size (meters):");
            this.jLabel2.setBounds(20, 170, 110, 25);
            this.jLabel2.setText("Grid Depth:");
            this.jPanel.add((Component)this.getJPanel1(), null);
            this.jPanel.add((Component)this.getDimField(), null);
            this.jPanel.add((Component)this.jLabel, null);
            this.jPanel.add((Component)this.jLabel1, null);
            this.jPanel.add((Component)this.getCellSize(), null);
            this.jPanel.add((Component)this.getShowValues(), null);
            this.jPanel.add((Component)this.getColorBtn(), null);
            this.jPanel.add((Component)this.getColor(), null);
            this.jPanel.add((Component)this.getCancelBtn(), null);
            this.jPanel.add((Component)this.getOkBtn(), null);
            this.jPanel.add((Component)this.jLabel2, null);
            this.jPanel.add((Component)this.getDepthField(), null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            GridLayout gridLayout1 = new GridLayout();
            this.jPanel1.setLayout(gridLayout1);
            this.jPanel1.setBounds(11, 13, 443, 60);
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Shown grids", 0, 0, null, null));
            gridLayout1.setRows(1);
            gridLayout1.setColumns(3);
            this.jPanel1.add((Component)this.getCheckNE(), null);
            this.jPanel1.add((Component)this.getCheckUN(), null);
            this.jPanel1.add((Component)this.getCheckUE(), null);
        }
        return this.jPanel1;
    }

    private JFormattedTextField getDimField() {
        if (this.dimField == null) {
            this.dimField = new JFormattedTextField(this.df);
            this.dimField.setBounds(160, 95, 60, 25);
        }
        return this.dimField;
    }

    private JCheckBox getCheckNE() {
        if (this.checkNE == null) {
            this.checkNE = new JCheckBox();
            this.checkNE.setText("North/East");
        }
        return this.checkNE;
    }

    private JCheckBox getCheckUN() {
        if (this.checkUN == null) {
            this.checkUN = new JCheckBox();
            this.checkUN.setText("Up/North");
        }
        return this.checkUN;
    }

    private JCheckBox getCheckUE() {
        if (this.checkUE == null) {
            this.checkUE = new JCheckBox();
            this.checkUE.setText("Up/East");
        }
        return this.checkUE;
    }

    private JFormattedTextField getCellSize() {
        if (this.cellSize == null) {
            this.cellSize = new JFormattedTextField(this.df);
            this.cellSize.setBounds(160, 132, 60, 25);
        }
        return this.cellSize;
    }

    private JCheckBox getShowValues() {
        if (this.showValues == null) {
            this.showValues = new JCheckBox();
            this.showValues.setBounds(280, 89, 124, 22);
            this.showValues.setText("Show values");
        }
        return this.showValues;
    }

    private JButton getColorBtn() {
        if (this.colorBtn == null) {
            this.colorBtn = new JButton();
            this.colorBtn.setBounds(305, 125, 100, 30);
            this.colorBtn.setText("Color...");
            this.colorBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = JColorChooser.showDialog(new JFrame(), "Select the grid color", Grid3D.this.getColor().getBackground());
                    if (c != null) {
                        Grid3D.this.getColor().setBackground(c);
                    }
                }
            });
        }
        return this.colorBtn;
    }

    private JButton getColor() {
        if (this.color == null) {
            this.color = new JButton();
            this.color.setBounds(280, 125, 25, 30);
            this.color.setEnabled(false);
            this.color.setBackground(Color.gray);
        }
        return this.color;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null) {
            this.cancelBtn = new JButton();
            this.cancelBtn.setBounds(353, 206, 100, 30);
            this.cancelBtn.setText("Cancel");
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Grid3D.this.setVisible(false);
                    Grid3D.this.dispose();
                }
            });
        }
        return this.cancelBtn;
    }

    private JButton getOkBtn() {
        if (this.okBtn == null) {
            this.okBtn = new JButton();
            this.okBtn.setBounds(246, 206, 100, 30);
            this.okBtn.setText("OK");
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Grid3D.this.setRenderer();
                    Grid3D.this.setVisible(false);
                    Grid3D.this.dispose();
                }
            });
        }
        return this.okBtn;
    }

    public static void showGridDialog(Renderer3D r3d) {
        Window parentFrame = SwingUtilities.getWindowAncestor(r3d);
        Grid3D g3d = parentFrame instanceof Frame ? new Grid3D((Frame)parentFrame) : new Grid3D(ConfigFetch.getSuperParentAsFrame());
        g3d.setRenderer3D(r3d);
        g3d.setVisible(true);
        g3d.setModal(true);
        GuiUtils.centerOnScreen(g3d);
    }

    private JFormattedTextField getDepthField() {
        if (this.depthField == null) {
            this.depthField = new JFormattedTextField(this.df);
            this.depthField.setBounds(160, 170, 60, 25);
        }
        return this.depthField;
    }

    public static void main(String[] args) {
        Grid3D.showGridDialog(new Renderer3D());
    }
}

